"The House of Mystery" by "James G. Lynch"

The story genre is "Fiction".

The story headline is "An Interactive Fantasy".

The story creation year is 2018.

The Release number is 5.

The story description is "A house in the middle of the woods has being sitting here for years. Rumors have speculated that the person who once owned this house has mysteriously disappeared off the face of the earth and no one seems to remember anything about it at all. Perhaps an unknown malevolent force has taken this poor soul away or maybe the house is haunted by a dark entity that is solely bent on destruction and chaos. As an investigator, it's up to you to check and see what secrets lie within this treacherous home. Uncover the lost bits of somebody's past and find out what really happened here many years ago.

This game was initially a project for my New Media Perspectives class in college. I was never expecting to make a fully finished game out of it, but after a while I began to get interested in what I was making and expanded upon what I've started. Now after about 2 months (4/10/18 - 6/8/18) of hard work I've been able to make my first ever text-based game. I hope you enjoy what I've made so far. If you ever happen to find a bug or any spelling/grammar error, please contact me at 0516jgl@gmail.com so that I can fix it ASAP. Thank you and enjoy! (PS: Anyone who sends me weird and stupid crap or whatever shall be blocked and/or put into the black hole that is my spam folder.)

Disclaimer: This game has some mild language and disturbing content that may not be comfortable for most people. It also includes a lot of satire, stupid inside jokes, and sass. If you're not a fan of anything humorous, leave now and not feel offended, because making jokes on the internet is apparently bad now. Not all content I include is rightful mine. Full credit goes to anything that is not owned by me, which includes references to a bunch of pop culture stuff. Quotes and all.

Original cover art made by AppleSin (Mistrie Orange). All rights reserved and such."

[Release Content]
Release along with cover art ("The book of void.").
Release along with the library card.
Release along with the private source text.
Release along with an introductory booklet and introductory postcard.
Release along with a "Classic" website.
Release along with the interpreter.
Release along with a solution.

[NOTICE TO DATAMINERS: Unless you know what exactly you are doing here, please refrain from changing any of code. This may cause the game to have frequent errors and crashes because of missing rules, unfinished actions, or words that the game does not comprehend so much. Inform 7 uses natural language as its code layer, in other words, it uses Standard English sentences as its coding and is a learning machine. If it happens to find something that it doesn't understand, it will refuse to play the game properly until the error has been fixed. I can't stop you from tearing this game piece by piece but I can warn you about the risks your about to experience and prevent unexpected consequences. If you do however find any problems or bugs in the game let me know so that I can resolve them as best as possible. Same thing goes for any grammar, spelling or punctuation you find. I tend to be a grammar nazi to myself every one in a while, especially when I just proofread this entire source layer like 10,000 times and still manage to overlook a misspelled word. Also the spell checker on this program is sometimes inaccurate. It's annoying, I know. But yeah, that's about it. Thanks for listening and enjoy this game to your hearts content!]

Section 0.1 - Extensions & Startup

[Built-in Extensions]
Include Basic Screen Effects by Emily Short.
Include Basic Help Menu by Emily Short.
Include Glulx Text Effects by Emily Short.
Include Debug Tags by Michael Kielstra.
Include Recorded Endings by Emily Short.
Include Questions by Michael Callaghan.

[Game Start]
When play begins:
	center "Welcome to 'The House of Mystery.'";
	wait for any key;
	say line break;
	center "You've been told to find out what happened here many years ago,";
	wait for any key;
	center "and know exactly what happened to the person who lived here.";
	wait for any key;
	center "Go now and solve the mystery but beware,";
	wait for any key;
	center "there are many traps and challenging puzzles for you to solve along the way.";
	wait for any key;
	center "The choices you make matter the most. Let's hope you make the best decisions.";
	wait for any key;
	center "Good Luck!";
	pause the game;
	now the left hand status line is "[location]";
	now the right hand status line is "Turns: [turn count]".

Before starting the virtual machine:
	now the left hand status line is "";
	now the right hand status line is "".

[Ending Recorder]
The File of Conclusions is called "deathlisting".

[Banner]
After printing the banner text: say "Type HELP, HINT, ABOUT, or INFO for options, hints, credits, and more. (All commands do the same thing.)"

Section 0.2 - Index

[In hand at Start]
The player is wearing a black cap and a brown jacket. The player is carrying a gold watch and small map. The description of the player is "Narcissist."
The printed name of the small map is "Map of the House".
Understand "map 1" as small map.

The description of the gold watch is "It's for when you need to know what time it is. You've had this watch ever since your grandfather passed away and you hold onto it as a treasured memory of him. Right now the watch hands are stuck because time is irrelevant in a game most of time."
The description of the black cap is "This cap has a symbol of that strange letter 'S' you and your classmate friends would draw in notebooks all the time. You have yet to know what that even means."
The description of the brown jacket is "This zipper jacket you wear is dated and on the front reads 'Abercrombie & Fitch: 1892.' You've had this since you were in middle school."

Instead of attacking yourself:
	say "Suicide is not a definite answer to any problem whatsoever. Stop it and get some help."
Instead of dropping the gold watch:
	say "That item is of importance to you. You cannot get rid of it."
Instead of dropping the brown jacket:
	say "That item is of importance to you. You cannot get rid of it."
Instead of dropping the black cap:
	say "That item is of importance to you. You cannot get rid of it."

[Turn counter]
Every turn when the turn count is 1996:
	say "Today, please. Today!"

Section 0.3 - Actions

[New actions list]
Kicking is an action applying to one thing.
Understand "kick [something]" as kicking.
After kicking something: 
	say "That is not acceptable behaviour."
After kicking the dog when the dog is tame for the first time:
	say "Don't kick the dog.";
	now the dog is startled;
	now the description of the dog is "The dog is [state]. Would be best to leave him alone."
After kicking the dog for the second time:
	say "I said don't kick the dog."
After kicking the dog for the third time:
	say " What part of 'don't kick dog' don't you understand."
After kicking the dog for the fourth time:
	record "Animal Abuser" as an ending;
	end the story saying "Ok, just for that I'm going to end the game for you because your being an abusive animal beater. Let's see what the animal rights association has to say about you."

Digging it with is an action applying to two things.
Understand "dig [something] with [something]" as digging it with.
After digging something with something:
	say "I don't think that will work."
Check digging it with:
	if the player is not carrying the shovel:
		say "You'll need a special tool first."

Breaking it with is an action applying to two things.
Understand "break [something] with [something]" as breaking it with.
After breaking something with something:
	say "That's not necessary most of the time."
Check breaking it with:
	if the player is not carrying the crowbar:
		say "You'll need something strong, stronger than a hammer possibly."

Saying sorry to is an action applying to one thing.
Understand "say sorry to [an animal]" as saying sorry to.
After saying sorry to something:
	say "What's there to apologize for?"

Playing is an action applying to one thing.
Understand "play [something]" as playing.
After playing something:
	say "You find no enjoyment in that."

Using it on is an action applying to two things.
Understand "use [something] on [something]" as using it on.
After using something on something:
	say "No effect."

Petting is an action applying to one thing.
Understand "pet [an animal]" as petting.
After petting the dog:
	say "You pet the dog. He enjoys that very much."
Instead of petting the dog when the dog is startled:
	say "Now is not the best time for that."
Instead of petting the dog when the dog is skiddish:
	say "He backs away from you."
Instead of petting the dog when the dog is upset:
	say "He refuses the offer and will not allow you to touch him."
Instead of petting the dog when the dog is stubborn:
	say "He's not in the mood for that."
After petting the stinkbug:
	say "I hope you'll wash your hands after this."

Walking up to is an action applying to one thing.
Understand "walk up to [something]" as walking up to.
After walking up to something:
	say "You feel closer than before."

Searching through is an action applying to one thing.
Understand "search through [something]" as searching through.
After searching through something:
	say "Nothing here."
Instead of searching through an animal:
	say "That command only works on inanimate objects."
Instead of searching through a man:
	say "Not a lot of humans are present this game to pick pockets except for you, but I have my doubts on that."

Hugging is an action applying to one thing.
Understand "hug [an animal]" as hugging.
After hugging the dog:
	say "You feel all warm and fuzzy inside."
Instead of hugging the dog when the dog is startled:
	say "Nope. Not today."
Instead of hugging the dog when the dog is skiddish:
	say "Your a monster to him so back off."
Instead of hugging the dog when the dog is upset:
	say "That does not work."
Instead of hugging the dog when the dog is stubborn:
	say "If this did constitute as 'saying sorry' I would allow it but since that's non-verbal and takes more work to code in, I can't.";
	say line break;
	wait for any key;
	say "Sorry."
Instead of hugging the stinkbug:
	say "I wouldn't."
Instead of hugging the fake dog:
	say "That dog rejects your emotional embraces."
Instead of hugging the white wyvern when the white wyvern is menacing:
	say "Please don't try."
Instead of hugging the white wyvern when the white wyvern is bewildered:
	say "Try something else."
Instead of hugging the white wyvern when the white wyvern is lonely:
	say "Walk up to him first. You're too far away."
After hugging the white wyvern when the white wyvern is content:
	say "Your friends would be so jealous if you told them about this."
After hugging the white wyvern when the white wyvern is glad:
	say "You're the best, you know that."
After hugging the white wyvern when the white wyvern is curious:
	say "He feels less lonely now that your here."
Instead of hugging a man:
	say "That's a bit weird."

Talking to is an action applying to one thing.
Understand "talk to [a person]" as talking to.
After talking to a person:
	say "No response."

[Useless commands just for laughs]
Swearing at is an action applying to one thing.
Understand "swear at [something]", "cuss at [something]", and "curse at [something]" as swearing at.
Instead of swearing at something: 
	say "Watch yo profanity! There are children playing this game, I think."

Vulgar language is an action applying to nothing.
Understand "arse", "ass", "bastard", "bitch", "bollocks", "bollox", "chode", "cock", "damn", "dick", "dildo", "douche", "douchebag", "fuck", "hell", "peck neck", "pecker", "piss", "prick", "schlong", "scrote", "twat", "wanker", and "whore" as vulgar language.
Report vulgar language:
	say "[one of]Well excussss me, princess![or]What yo mouth here, will ya![or]Dude, just... stop.[or]Hmpf, wow.[or]Don't look at me, you're the one who was curious if you could say such language here.[or]Do you kiss your mother with that mouth?[or]I hope you're using proxy.[or]I'm getting the soap.[or]Oh, I see you wanna play it that way.[or]Please stop. You'll make this look bad for the both of us.[or]Let's be honest here, we knew you were going to try this out eventually, since you do have the power to type whatever you want down. That, however, does now change the fact that you shouldn't say stuff like this either way.[or]You are a monster and a dirty pile of scum. Please stop this insensible behavior at once.[or]![or]I think I hear someone at your door. Hide... Now.[at random]".

Marrying is an action applying to one thing.
Understand "marry [something]" as marrying.
Instead of marrying something:
	say "I'm pretty sure nothing in this game understands what the emotion of 'love' is. Not even myself and that's saying something."

Escaping is an action applying to nothing.
Understand "escape" and "run away" as escaping.
Instead of escaping:
	say "What are you running away from?"

Instead of kissing an animal:
	say "That's... um, no."
Instead of kissing a man:
	say "I can't allow that due to... certain conditions that I cannot explain in full details."
Instead of attacking the dog:
	say "No!"
Instead of marrying the dog:
	say "That's not necessary. (Not even you can repair his broken heart.)"

Telling the computer its stupid is an action applying to nothing.
Understand "Tell the computer its stupid", "Tell the game its stupid", and "Tell the creator he's stupid" as telling the computer its stupid.
After telling the computer its stupid:
	say "I may be stupid, but at least I have common sense."

Dividing zero is an action applying to nothing.
Understand "divide 0 by 0" as dividing zero.
After dividing zero:
	say "So you want me to implode time and space as we know it. Is that it? Well... I can't. For starters that's logically impossible. If I were to do that then me, you, this game and every other thing in this known universe would collapse in on itself and cease to exist for all of eternity because you decided to wanted to make a stupid hard task a possible outcome. But if this still does not suffice you then maybe you should ask Siri and hear what she has to say about your unobtainable request."

Cheating is an action applying to nothing.
Understand "UUDDLRLRBA" as cheating.
After cheating:
	say "Sorry, I don't speak Konami."

After jumping:
	say "What are you a plumber?";
	if player consents:
		say "Well too bad. You move-set is in another castle.";
		wait for any key;
		say "And also your princess.";
	otherwise:
		say "Oh really?"

[Water rule]
A thing can be waterproof or porous. A container is usually waterproof. An animal is usually waterproof.

A thing can be sodden or dry.

A container can be waterfilled or empty.

Before printing the name of a sodden thing: say "sodden ". Understand the sodden property as describing a thing.

Every turn:
	follow the liquid distribution rules. 

The liquid distribution rules is a rulebook.

A liquid distribution rule: 
	repeat with item running through containers: 
		if the item is open and the item is empty and the item is in a waterfilled container: 
			now the item is waterfilled; 
			if the player can see the item, say "[The item] fills up with water, of course.".

A liquid distribution rule: 
	repeat with item running through things in a waterfilled container: 
		if the item is porous and the item is dry: 
			if the player can see the item, say "[The item] soaks through."; 
			now the item is sodden.

Filling it with is an action applying to two things.
Understand "fill [container] with [something]" as filling it with.
Check filling it with:
	if the player is not carrying the bucket:
		say "To do this, you'll need an empty container."

Pouring it on is an action applying to two things.
Understand "pour [container] on [something]" as pouring it on.
Check pouring it on:
	if the player is not carrying the bucket:
		say "To do this, you'll need a filled container."

[Battle mechanics]
Dodging is an action applying to one thing.
Understand "dodge [a man]" and "guard [a man] attack" as dodging.

[Block/Unblock rules list]
The can't take other people rule is not listed in the check taking rulebook. [Living creatures are carryable now. Needed for dog later.]

The block attacking rule is not listed in the check attacking rulebook. [Now you can defend yourself unless you have a weapon.]
After taking the butcher's knife:
	say "Now you can defend yourself if needed."
After taking the shovel:
	say "Now you have a bit of defense and offense on your side.";
	now the description of the dirt pile is "There's something strange about this mound of dirt."
After taking the crowbar:
	say "Now you have a REAL weapon of destruction. (Don't actually break everything on sight please. 'Play responsibly,' says literally every casino on this planet.)"
Check attacking:
	if the player is not carrying the butcher's knife:
		say "You need something to attack with. Your bare hands will not do."

The block throwing at rule is not listed in the check throwing it at rulebook.
The futile to throw things at inanimate objects rule is not listed in the check throwing it at rulebook.
After taking the rock:
	say "This could come in handy maybe."
Check throwing at:
	if the player is not carrying the rock:
		say "Whatever you have on you is not good for chucking."
After throwing the rock at a window:
	record "7 Years of More Bad Luck" as an ending;
	end the story saying "Your not good at listening to me, are you."
After throwing the rock at a stained window:
	record "7 Years of Filthy Bad Luck" as an ending;
	end the story saying "Your not good at listening to me, are you."

[Fake command]
To fake command:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "G";
	wait for any key;
	say "a";
	wait for any key;
	say "m";
	wait for any key;
	say "e";
	wait for any key;
	say " ";
	wait for any key;
	say "O";
	wait for any key;
	say "v";
	wait for any key;
	say "e";
	wait for any key;
	say "r";
	wait for any key;
	say roman type;
	say line break;

To fake command 2:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "I'm";
	wait for any key;
	say " here";
	wait for any key;
	say " for";
	wait for any key;
	say " you.";
	wait for any key;
	say roman type;
	say line break;

To fake command 3:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "Y";
	wait for any key;
	say "e";
	wait for any key;
	say "s";
	wait for any key;
	say roman type;
	say line break;

Section 0.4 - Things

[Damaged Things]
A thing can be damaged or undamaged.
The trap door is undamaged.
The clown doll is undamaged.

[Thing multiplier list]
[Chairs]
A chair is a kind of enterable supporter.
The white chair is a chair.
The small chair is a chair.
The recliner chair is a chair.
The broken recliner chair is a chair.
The black chair is a chair.
The bloody chair is a chair.
The shattered chair is a chair.
The piano bench is a chair.
The sturdy stool is a chair.
The non-sturdy stool is a chair.

A withered chair is a kind of enterable supporter.

[Couches]
A couch is a kind of enterable supporter.
The large couch is a couch.
The small couch is a couch.
Understand "sofa" as couch.

A shredded couch is a kind of enterable supporter.
Understand "sofa" as shredded couch.

[Beds]
A bed is a kind of undamaged enterable supporter.
The queen-size bed is a bed.
The guest bed is a bed.
The master's bed is a bed.
The wrecked bed is a bed.
The king-size bed is a bed.
The torn-up bed is a bed.

[Sinks]
A sink is a kind of device.
The duel sink is a sink.
The small sink is a sink.
The small upstairs sink is a sink.
The inverted sink is a sink.
The twin sink is a sink.
The warped sink is a sink.

[Toilets]
A toilet is a kind of enterable supporter.
The fancy toilet is a toilet.
The small toilet is a toilet.
The inverted toilet is a toilet.
The bent toilet is a toilet.

[Tables]
A table is a kind of supporter.
The coffee table is a table.
The large table is a table.
The desk is a table.
The split table is a table.
The worn-out table is a table.
The bloody table is a table.
The broken desk is a table.

[Windows]
A window is a kind of scenery thing.
The large window is a window.
The upstairs window is a window.
The cracked large window is a window.

A stained window is a kind of scenery thing.

[TV's]
A television is a kind of device.
The old television is a television.
The small television is a television.
The dead television is a television.
The small broken television is a television.
Understand "tv" and "boobtube" as television.

[Cages]
A rickety cage is a kind of enterable container.

[The Mysterious Papers]
A mysterious paper is a kind of thing.
Note #1 is a mysterious paper.
Note #2 is a mysterious paper.
Note #3 is a mysterious paper.
Note #4 is a mysterious paper.
Note #5 is a mysterious paper.
Note #6 is a mysterious paper.
Note #7 is a mysterious paper.
Note #8 is a mysterious paper.
Note #9 is a mysterious paper.
Understand "Note 1" as Note #1. Understand "Note 2" as Note #2. Understand "Note 3" as Note #3. Understand "Note 4" as Note #4. Understand "Note 5" as Note #5. Understand "Note 6" as Note #6. Understand "Note 7" as Note #7. Understand "Note 8" as Note #8. Understand "Note 9" as Note #9.

Instead of dropping a mysterious paper:
	say "This is important, don't lose it."

[Undead creatures]
A zombie is a kind of man.
Zombie 1 is a zombie. The printed name of Zombie 1 is "A Zombie".
Zombie 2 is a zombie. The printed name of Zombie 2 is "The Left Zombie".
Zombie 3 is a zombie. The printed name of Zombie 3 is "The Right Zombie".
Zombie 4 is a zombie. The printed name of Zombie 4 is "The Middle Zombie".
Zombie 5 is a zombie. The printed name of Zombie 5 is "The Final Zombie".
Understand "undead" as zombie.
Understand "left zombie" as Zombie 2.
Understand "right zombie" as Zombie 3.
Understand "middle zombie" as Zombie 4.

Instead of taking a zombie:
	say "That's not allowed."
Instead of walking up to a zombie:
	say "Keep your distance."

[Liquid Water]
Water is a kind of thing.
Water 1 is water. The printed name of water 1 is "water".
Water 2 is water. The printed name of water 2 is "water".
Water 3 is water. The printed name of water 3 is "water".
Water 4 is water. The printed name of water 4 is "water".
Water 1 is part of the waterfalls.
The description of water is "H2O: Your number one thirst quencher."

Instead of drinking the water:
	say "You drank the water. It was refreshing."
After touching the water:
	say "The water feels nice on the hands."

Section 0.5 - Values

[Mental states]
State is a kind of value. The states are content, startled, tame, upset, skiddish, chill, stubborn, calm, menacing, lonely, confused, bewildered, curious, scared, agitated, unamused, glad, sad, petrified, mortified, worried, disgusted, and quiet.

A dog is an animal. The dog is male. The dog has a state. The dog is tame.
The printed name of the dog is "Australian Shepherd".

The white wyvern has a state. The white wyvern is menacing.

[Level]
Level is a kind of value. The levels are activated and still.

The light switch has a level. The light switch is still.
The keypad has a level. The keypad is still.

[Physical attributes]
Attribute is a kind of value. The attributes are smoldering, soggy, cool, attack, dodge, vulnerable, and wait.

The fireplace has an attribute. The fireplace is smoldering.
The firewood has an attribute. The firewood is smoldering.

Zombie 1 has an attribute. Zombie 1 is attack.
Zombie 2 has an attribute. Zombie 2 is attack.
Zombie 3 has an attribute. Zombie 3 is wait.
Zombie 4 has an attribute. Zombie 4 is wait.
Zombie 5 has an attribute. Zombie 5 is attack.

[Final Boss patterns]
Attack pattern is a kind of value. The attack patterns are charging, guarding, and defenseless.

The doppleganger has an attack pattern. The doppleganger is guarding.

Section 0.6 - Figures

[2 Maps]
Figure 1 - Map is the file "New Map 1.png".
Figure 2 - New Map is the file "New Map 2.png".

[1st Map]
The description of the small map is "Here's a map of the entire house. The abbreviations of each room goes from First Floor, Second Floor, and Lower Floor:[paragraph break]LR - Living Room (Your starting point)[line break]DR - Dining Room[line break]Kt - Kitchen[line break]HI - Hallway[line break]Bd - Bedroom[line break]Bt - Bathroom[line break]Md - Mudroom[line break]Bc - Backyard[paragraph break]SF - Second Floor[line break]UB - Upstairs Bathroom[line break]GB - Guest Bedroom[line break]MB - Master Bedroom[paragraph break]Bs - Basement[line break]Cl - Cellar[line break]Bc - Backroom[line break](CE is not a room that can be entered unless a certain requirement is made.)[paragraph break]Directions: North, South, East, West, Up, Down, Outside, and Inside".

After examining the small map:
	display Figure 1 - Map.

Instead of dropping the small map:
	say "That's an important item. You can't afford to lose it."

[2nd Map]
The large map is a thing.
The printed name of the large map is "Map of the House (Updated)".

The description of the large map is "I hope you remembered:[paragraph break]Left half: Original House[line break]Right half: Inverted House".

After examining the large map:
	display Figure 2 - New Map.

Instead of dropping the large map:
	say "That's still important. Don't go throwing it away."

[Other Figures]
Figure 3 - Old Map 1 is the file "Map 1.png".
Figure 4 - Old Map 2 is the file "Map 2.png".
Figure 5 - Cover Art is the file "Cover.jpg".
Figure 6 - Small Cover Art is the file "Small Cover.jpg".
Figure 7 - Compass is the file "unnamed.png".
Figure 8 - Dormouse is the file "21485.jpg."
Figure 9 - Australian Shepherd is the file "Australian-Shepherd.1.jpg".
Figure 10 - Brown Marmorated Stink Bug is the file "220px-Pentatomidae_-_Halyomorpha_halys-001.jpg".
Figure 11 - Lisa Conley Rainbow Tarantula is the file "7ea9187d44a47fb6bad4ead7f65efd75--spider-rainbows.jpg".
Figure 12 - Ghost Werewolf is the file "1233039_223293621162608_1941911683_o.jpg".
Figure 13 - Snow White Wyvern is the file "faa3e06fba529b6e435f3350208151ca--draco-lets-go.jpg".

[Dormouse - https://canalrivertrust.org.uk/enjoy-the-waterways/canal-and-river-wildlife/a-spotters-guide-to-waterway-wildlife/dormouse-waterway-wildlife]
[Dog - https://www.akc.org/dog-breeds/australian-shepherd/]
[Stinkbug - https://en.wikipedia.org/wiki/Brown_marmorated_stink_bug]
[Spider - https://www.pinterest.com/pin/203084264416843097][CAUTION: Don't look up link if you have arachnophobia. Stinkbugs? Ha! Those aren't creepy.]
[Werewolf - http://www.ongoingworlds.com/blog/2014/11/random-ghost-werewolf-vampire-zombie-description-generator/]
[Wyvern - https://www.pinterest.com/pin/418201515390929238]

[Picture Sign]
After examining Sign 5:
	say "First map given to you at the start:";
	display Figure 1 - Map;
	wait for any key;
	say "Second map for dark world:";
	display Figure 2 - New Map;
	wait for any key;
	say "The compass used for the maps was found on [italic type]http://eufami.org/2018/03/26/the-eu-compass-for-action-on-mental-health-and-wellbeing/[roman type]";
	display Figure 7 - Compass;
	wait for any key;
	say "Cover art for the game in high definition. Original designer's name is in the description on the website and in the credits tab of the help menu.[line break]Link: [italic type]https://www.deviantart.com/applesin/art/Book-of-Void-379808983[roman type]";
	display Figure 5 - Cover Art;
	wait for any key;
	say "Cover art shrunken down to 120 by 120 pixels to meet requirements for Inform to recognize properly:";
	display Figure 6 - Small Cover Art.

[Unused Sign]
After examining Sign 6:
	say "Unfiltered starter map with no compass. (Used in Version 1.0)";
	display Figure 3 - Old Map 1;
	wait for any key;
	say "Updated clean map for dark world with no compass. (Also in Version 1.0)";
	display Figure 4 - Old Map 2;
	wait for any key;
	say "Compass item was not introduced yet. This picture could be used for the item, but would need serious editing done and size reduction.";
	display Figure 7 - Compass;
	wait for any key;
	say "Music was planned to be used, but was just an afterthought. It may not possible for Inform to loop songs for background music though. From what I know, Inform only does sound effects like doors shutting and glass breaking. Then there's the fear of copyright claim even when credit is given.";
	say line break;
	wait for any key;
	say "Background images are also not possible from what I know, but you can change the color of the background in Z-Code. However, this is Glulx and I'm told the built-in extension 'Basic Screen Effects by Emily Short' doesn't run on Glulx. 'Glulx Text Effects,' on the other hand, can do the same thing, but would need to be defined and used. I can't change it to Z-Code either because this game is too big. Z-Code has its limits on word count but Glulx doesn't and this game has went way past the limit.";
	say line break;
	wait for any key;
	say "Various images of the creatures used in the game have unused pictures. Here's a few of them:";
	say paragraph break;
	wait for any key;
	say "Australian Shepherd - (https://www.akc.org/dog-breeds/australian-shepherd/)[line break]Note: This is not my dog. Mine is a mixed breed.";
	display Figure 9 - Australian Shepherd;
	wait for any key;
	say "Brown Marmorated Stink Bug - (https://en.wikipedia.org/wiki/Brown_marmorated_stink_bug)[line break]Yes, this one is from wikipedia.";
	display Figure 10 - Brown Marmorated Stink Bug;
	wait for any key;
	say "Clock Dormouse - (https://canalrivertrust.org.uk/enjoy-the-waterways/canal-and-river-wildlife/a-spotters-guide-to-waterway-wildlife/dormouse-waterway-wildlife)[line break]Name was changed due to the Computers extension mentioning mouse as not an animal anymore, so I googled a synonym for mouse and found this. They look like really cute chinchillas, which makes me not want to change the name back. They can be found in Europe if you're curious.";
	display Figure 8 - Dormouse;
	wait for any key;
	say "[bold type]WARNING: SPIDER PICTURE INCOMING!!![roman type]";
	say line break;
	wait for any key;
	say "Spider on the Water Faucet - (https://www.pinterest.com/pin/203084264416843097)[line break]At least be happy I found the least creepiest picture. Plus the colors look cool.";
	display Figure 11 - Lisa Conley Rainbow Tarantula;
	wait for any key;
	say "Ghostly Werewolf - (http://www.ongoingworlds.com/blog/2014/11/random-ghost-werewolf-vampire-zombie-description-generator/)[line break]The name was changed to fit the fact of werewolves being afraid of silver.";
	display Figure 12 - Ghost Werewolf;
	wait for any key;
	say "Flahmie - (https://www.pinterest.com/pin/418201515390929238)[line break]I made slight modifications to the name of the white wyvern, but still kept the reference as clear as possible. Also I was going to use that one picture in the Terraria Steam Trading Cards but said 'Nah, this picture looked better.' Looking up picture for a wyvern and then choosing one was not easy.";
	display Figure 13 - Snow White Wyvern;
	wait for any key;
	say "Characters with no images:[paragraph break]Zombies - (You know what they look like.)[line break]The Clown - (I left out this one for your sakes. Your welcome Coulrophobic's.)[line break]Doppleganger - (Think of it as a Mimic; It has no absolute shape or form. It can only be what it becomes.)[line break]Minor background creatures - (Birds, Ghost, Time Wisp, etc.)[line break]You (The Protagonist) & Micheal - (Be creative with these two. Your imagination is all you really need.)";
	say line break;
	wait for any key;
	say "Various extensions were unused as well. Here's some I've used but decided to leave because they were either to complicated to understand, cause errors due to certain rules being broken, or would not work as planned:[paragraph break]Computers Ver. 7 - Emily Short (Built-In)[line break]Computers Ver. 5 - Emily Short (Still left in the files untouched.)[line break]Glulx Image Centering - Emily Short (Installed by other extensions but is not in use.)[line break]Glulx Text Effects - Emily Short (Certain text formats are not in use.)[line break]Measured Liquid - Emily Short (Used once for water but would cause errors in the extension itself. The only way to fix it was to start the project from stratch and avoid clutter.)[line break]Plurality - Emily Short (Still in the files unused.)Power Sources - Emily Short ( Was supposed to function along with the Computers extension.)[line break]Tutorial Mode - Emily Short (Not sure if I wanted to use this one.)[line break]Unicode Full Character Names - Graham Nelson (I was afraid to use this one because it said it would slow Inform down.)[line break]Achievements - Juhana Leinonen (Still thinking about this one.)[line break]All 6 Vorple extensions -  Juhana Leinonen (I already explained why it's not in use anymore.)[line break]Plugs and Sockets - Sean Turner (Also was needed in Computers.)[line break]All other built-in extensions are downloaded but are not active.";
	say line break;
	wait for any key;
	say "Source code used to have HTML links in the pre-made website for the game, but have been deleted and is still switched to private. Despite being privated, the source file can still be accessed from the game files.";
	say line break;
	wait for any key;
	say "That's about everything. Thank you![line break]PS: You can invert the pictures by triple clicking or by highlighting it for some reason. I figured this out myself when making this list."

Section 0.7 - Conversations

[The dog]
After talking to the dog for the first time:
	say "He's not one to say much, because he's a dog. But you can tell what he has to say just by using telepathy. How do you have telepathy you ask? I don't know, that's something we can explain another day, ok? Anyways you can ask him about anything relevent to this world. Type 'ask (living creature) about (topic/text)' for information on certain things of the place.[paragraph break]Example:[line break]>ask the dog about the house[paragraph break](Note: Certain NPC's cannot be talked to or asked about things. Also, the game is fixated with certain texts for asking NPC's about things and will not answer to all things related to the game because that is too much coding to put in. Check the source text if you want to know about the certain topics given, or don't. I don't really care as long as you are having some fun some way.)"
After talking to the dog:
	say "He's not one to say much, because he's a dog. But you can tell what he has to say just by using telepathy. How do you have telepathy you ask? I don't know, that's something we can explain another day, ok? Anyways you can ask him about anything relevent to this world. Type 'ask (living creature) about (topic/text)' for information on certain things of the place.[paragraph break]Example:[line break]>ask the dog about the house[line break]".
After asking the dog about "the house":
	say "He doesn't like talking about his own home."
After asking the dog about "Micheal":
	say "(Maybe you should ask something else.)"
After asking the dog about "Flahmie":
	say "He's dead silent."
After asking the dog about "the notes":
	say "His minds a bit foggy about these notes."
After asking the dog about "the machines":
	say "That was a long time ago and doesn't even remember where their at."

[The mouse]
After talking to the dormouse:
	if the white wyvern is menacing:
		say "She has much to say about this place. First thing she mentions is that there is a wyvern in the bloodroom. His name is Flahmie. He's been trapped here as long as she has been. She asks that if you see him down there, don't listen to the person in your head telling you to stay away for him. He's a really kind, gentle soul and is only in deep agony and loneliness. Walk up to him and pet him. He really needs some more company, besides herself, to make him feel better about himself.";
		now the printed name of the white wyvern is "white wyvern (Flahmie)";
		now the white wyvern is lonely;
		now the description of the Bloodroom is "There he is. Go up to him.";
		now the dusty platform is nowhere;
		now the description of the white wyvern is "His head is down in grief when you first spot him. He lifts his head up slowly to see you and looks at you with weary.";
	otherwise:
		say "She has much to say about this place. First thing she mentions is that there is a wyvern in the bloodroom. His name is Flahmie. He's been trapped here as long as she has been. She asks that if you see him down there, don't listen to the person in your head telling you to stay away for him. He's a really kind, gentle soul and is only in deep agony and loneliness. Walk up to him and pet him. He really needs some more company, besides herself, to make him feel better about himself."
After asking the dormouse about "the house":
	say "It's been a while since she saw the outside world. All she can tell you is not to trust everything you see here."
After asking the dormouse about "Micheal":
	say "She used to know that man before he disappeared. When she was young, she lived a house next door to him.";
	wait for any key;
	say "Micheal would always be busy in his work and she would always hear him from underneath the ground.";
	wait for any key;
	say "Whatever happened to him was not a pleasant one.";
	wait for any key;
	say "She can barely make out the rest.";
	wait for any key;
	say "As for herself, she wondered off into this strange world and never came back."
After asking the dormouse about "the clock":
	say "It's nice and cozy. She would often get freaked out over the clocks chime each hour.";
	wait for any key;
	say "But then, one day, it broke all of a sudden and she left it that way."
After asking the dormouse about "going home":
	say "She's been thinking of going back home for a long time. But she can't help but think that he's still here somewhere."
After asking the dormouse about "Flahmie":
	say "She doesn't seemed intimidated about a dragon existing in this realm.";
	wait for any key;
	say "If your planning on seeing him she suggests you approach him slowly.";
	wait for any key;
	say "He may look big and ferocious, but he's actually gentle and is feeling troubled.";
	wait for any key;
	say "She pities him."
After asking the dormouse about "the notes":
	say "That guy was always writing logs about himself, as if expecting someone to read them when the time came.";
	wait for any key;
	say "He may have been foreshadowing his own future to come."
After asking the dormouse about "the machines":
	say "Those bring back terrible memories to her."

[The wyvern]
After talking to the white wyvern:
	if the white wyvern is content:
		say "He's not one to talk but is willing to mention anything that particularly strikes his interest.";
	otherwise:
		say "[if the white wyvern is curious]From what you've gathered, he is indeed a quiet and timid one. Although he is not shy to open up a bit and vent out his frustration on his past life.[end if][if white wyvern is glad]It's not easy being a gigantic ferocious looking creature, but he manages to stay calm and content as best as possible."
After asking the white wyvern about "itself":
	if the white wyvern is content:
		say "He's been here for a long time, waiting for him to come back.";
	otherwise:
		say "[if the white wyvern is curious]He wants to leave but only after everything has been resolved.[end if][if white wyvern is glad]He was once a loyal guardian to his master but was casted away back into the egg after the incident happened in the lab."
After asking the white wyvern about "Micheal":
	if the white wyvern is content:
		say "That's a name he wishes to not hear.";
	otherwise:
		say "[if the white wyvern is curious](Perhaps you should talk about something else.)[end if][if white wyvern is glad]If only he knew what went wrong, maybe he could've prevented it all."
After asking the white wyvern about "the egg":
	if the white wyvern is content:
		say "Even though he were still in the egg at the time, he could still sense everything from outside.";
	otherwise:
		say "[if the white wyvern is curious]After he was put into the fridge, he went into a state of hibernation and woke up here somehow.[end if][if white wyvern is glad]He's glad to know that you were able to bring him out of his eternal slumber.";
		wait for any key;
		say "[if white wyvern is glad]When this all over, he hopes to see you again in the real world."
After asking the white wyvern about "the house":
	if the white wyvern is content:
		say "This other house was made after that catastrophe happened.";
		wait for any key;
		say "After that, he lost all hope in everything and fell into a state of depression and grief for some time.";
	otherwise:
		say "[if the white wyvern is curious]While he may still be holding a grudge against him, he can't stay mad about it.[end if][if white wyvern is glad]Despite being a massive creature that is considerably the most terrifying thing in this entire world, even he is afraid of this creepy and demented house.";
		wait for any key;
		say "[if the white wyvern is curious]His only wish to be free from the cursed land."
After asking the white wyvern about "the room":
	if the white wyvern is content:
		say "This room was like this when he got here.";
		wait for any key;
		say "It may had to do with what happened downstairs.";
		wait for any key;
		say "He dares not to even speak about the screams he heard down there.";
	otherwise:
		say "[if the white wyvern is curious]Even with all this red he still managed to stay clean and white without any horrible stains.[end if][if white wyvern is glad]He says this place was like this before he came here. The fact that this room is completely tainted with red still gives him an unwelcoming vibe."
After asking the white wyvern about "the notes":
	if the white wyvern is content:
		say "That's none of his business to be concerned about.";
	otherwise:
		say "[if the white wyvern is curious]It would hurt him to hear his words again.[end if][if white wyvern is glad]These notes are the only memory he has of him and he chooses to forget the past and think about the present instead."
After asking the white wyvern about "the mouse":
	if the white wyvern is content:
		say "She was the only real company he had every once in the while.";
		wait for any key;
		say "She understands his struggle and watches over him.";
		wait for any key;
		say "He appreciates the support she gives.";
	otherwise:
		say "[if the white wyvern is curious]He wonders how she is doing up there.[end if][if white wyvern is glad]She's in denial, he's in denial. They both have something that makes them good friends."

[The zombie]
After asking a zombie about "thriller":
	say "The zombie begins to dance as you mentioned this to it."

Section 0.8 - Debugs & Cheats - Not for release

[None of them for you. Move along.]
Universal rule 1 is an action applying to nothing.
Understand "imsickofalltheselockeddoors" as universal rule 1.
Carry out universal rule 1: now all doors are unlocked;
now all doors are open.
Report universal rule 1: say "Open Sesame!"

Universal rule 2 is an action applying to nothing.
Understand "magicmirroronthewall" as universal rule 2.
Carry out universal rule 2: now the player is carrying the scepter.
Report universal rule 2: say "Whose the fairest? Not you, cheater!"

Universal rule 3 is an action applying to nothing.
Understand "myheadisnaked" as universal rule 3.
Carry out universal rule 3: now the player is carrying the red pinned hat.
Report universal rule 3: say "Then don't go out in public."

Universal rule 4 is an action applying to nothing.
Understand "itsfreezinginhere" as universal rule 4.
Carry out universal rule 4: now the player is carrying the thermal coat.
Report universal rule 4: say "Then put on some layers."

Universal rule 5 is an action applying to nothing.
Understand "lightsplease420" as universal rule 5.
Carry out universal rule 5: now all rooms are lit.
Report universal rule 5: say "Let there be light!"

Universal rule 6 is an action applying to nothing.
Understand "sorrynotsorry" as universal rule 6.
Carry out universal rule 6: now the dog is content.
Report universal rule 6: say "That's such a stupid phrase."

Universal rule 7 is an action applying to nothing.
Understand "secretofmana" as universal rule 7.
Carry out universal rule 7: now the white wyvern is content.
Report universal rule 7: say "Have you ever played it?"

Universal rule 8 is an action applying to nothing.
Understand "takingnotes" as universal rule 8.
Carry out universal rule 8: now the player is carrying Note #1;
now the player is carrying Note #2;
now the player is carrying Note #3;
now the player is carrying Note #4;
now the player is carrying Note #6;
now the player is carrying Note #7;
now the player is carrying Note #8;
now the player is carrying Note #9.
Report universal rule 8: say "Gotta read [']em all!"

Universal rule 9 is an action applying to nothing.
Understand "ruinthefun" as universal rule 9.
Carry out universal rule 9: now the player is carrying the Excalibur;
now the player is in the Arena.
Report universal rule 9: say "Thou art has doth ruin thee fun."

The Excalibur is a thing.

Hitting it with is an action applying to two things.
Understand "hit [a man] with [something]" as hitting it with.

After hitting the doppleganger with the Excalibur:
	say "Doppleganger: 'YoU sUck ChEeEeEEEeEEEeeeaAAaaAaaatTTtttTTTteeRr!'";
	now the doppleganger is nowhere;
	now the left hand status line is "";
	now the printed name of the Arena is "???";
	now the description of the Arena is " ";
	now the dog is in the Arena;
	now the printed name of the dog is "Australian Shepherd";
	now the dog is quiet;
	now the description of the dog is "(Take the book.)";
	wait for any key;
	say "[bold type]BOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOM!!!1!1![roman type]";
	wait for any key;
	clear only the main screen;
	now the reversed book is in the Arena.

Shitting is an action applying to nothing.
Understand "shit", "crap", "poop", and "#2" as shitting.
Instead of shitting:
	say "[one of]Let's not do that.[or]If you need to go, go to a toilet already.[or]That's just...[or]Oh my god.[or]You know, if your using this command in the game it's proof that your cheating somehow.[at random]".
Instead of shitting when the player is on a toilet:
	say "Why did I make this a command?"

[To-do list] [18/18 Complete]
[1# Use the BENT rule is a NOTE.]

[2# Implement a hint system is a IDEA.] [Hopefully soon][Hopefully now.]

[3# Change the chains to ropes is a TODO.]

[4# Fix dirt puzzle is a TODO.]

[5# Use the TALK command instead of ASK command for NPC's is a TODO.] [Both are implemented]

[6# Find an alternative to the silverware puzzle is a TODO.] [Fake dog is a ghost werewolf now; werewolves fear silver]

[7# Improve the WALK UP TO command is a FIXME.] [Two options to complete wyvern puzzle; talking to mouse is the new option]

[8# Improve wyvern puzzle is a FIXME.] [Name also changed slightly]

[9# Fix the trash can search is a FIXME.] [Old method is somewhat removed]

[10# Fix the cake part is a TODO.]

[11# Give better clarity to fireplace is a TODO.]

[12# Give water flow to certain sinks instead of Dungeon is a TODO.]

[13# Change up the wisp puzzle is a TODO.]

[14# Fix up the WAIT command is a FIXME.]

[15# Remove less O's in a certain text is a BUG.]

[16# Figure out what to do on talking to Micheal is a QUESTION.] [Added a new option of examining the man]

[17# Maybe change Micheal's name is a IDEA.] [Possibly unnecessary]

[18# Delete ending list and Delete source HTML files is a STOPSHIP.] [Always double-check]

Section 0.9 - Tables

[Contact Info, Hints, Settings & More]
Table of Basic Help Options (continued)
title	subtable	description	toggle
"Hints (CAUTION: Spoilers)"	Table of Useful Hints	--	a rule
"Game can't understand me"	Table of Misinformation	--	--
"Contacting the author"	--	"If you have any difficulties or find any bugs or errors within [story title], please contact me at 0516jgl@gmail.com and tell me what I did wrong.[paragraph break]PS: Don't send me anything unrelated to the game. I'm not one to listen to everybody's problems and its also none of my business to know. I'm not saying it to be mean or anything but please, keep things related to the topic. Thank you."	--
"Settings"	Table of Setting Options	--	--
"About the Author"	--	"[story author] is too reclusive to disseminate any information in this section. Sorry."	--
"Credits"	--	"Game made on Inform 7[paragraph break][bold type]Game made by:[roman type][line break]James G. Lynch[paragraph break][bold type]Beta-Testers:[roman type][line break]David Waring[line break]Dan Fabulich[paragraph break][bold type]Cover art by:[roman type][line break]AppleSin (Mistrie Orange)[paragraph break][bold type]Game Images:[roman type][line break]Google Images[line break]Deviant Art[line break]Pinterest[paragraph break][bold type]'Game can't understand me' Original Idea:[roman type][line break]Robert Janelle & Brad O'Donnell, creators of 'Nine Points.' (Fun Facts: This was the first game that showed me what Inform was and how it works.)[paragraph break][bold type]Miscellaneous:[roman type][line break]http://www.tongue-twister.net/en.htm[line break]AKC.org[line break]CanalRiverTrust.org.uk[line break]OnGoingWorlds.com[line break]Google (Duh...)[line break]Wikipedia (Maybe)[paragraph break][bold type]Special Thanks & Support:[roman type][line break]New Media Perspectives Professor and Peers, Mom & Dad, Sis, Dogs, entire family and friends,[line break]...and You.[paragraph break][italic type]J-Games Co. 2018 (It's a working title. Someone thought James Games sounded cool because it rhymed. Don't ask me why.)[roman type]"	--

[Hint List]
Table of Useful Hints
title	subtable	description	toggle
"What do I do first?"	Table of First Action	""	hint toggle rule
"How do I unlock the front door?"	Table of Front Door	""	hint toggle rule
"How do I unlock the back door?"	Table of Back Door	""	hint toggle rule
"How to get upstairs."	Table of Endless Stairs	""	hint toggle rule
"Where's the hat?"	Table of Hats	""	hint toggle rule
"How to unlock the Master Bedroom."	Table of Master Bedroom	""	hint toggle rule
"What to do with the ink bottle?"	Table of Ink	""	hint toggle rule
"How to get to the Basement."	Table of Eternal Darkness	""	hint toggle rule
"What do I do in the Basement?"	Table of Basement Tasks	""	hint toggle rule
"Doing multiple tasks."	Table of Multitasking	""	hint toggle rule
"What to do with the egg?"	Table of Eggcellence	""	hint toggle rule
"Finding the Master's key."	Table of Keybranding	""	hint toggle rule
"What to do in the Master's Bedroom."	Table of Neutral Ending	""	hint toggle rule
"The Good Ending."	Table of Better Ending	""	hint toggle rule
"Room No. 36"	--	"ERROR: 404[paragraph break]Room name <ɯooɹƃnqǝp> doesn't exist.[line break]Sinks are in need of maintenance."	--

Table of First Action
hint	used
"For newcomers, first thing you must do is read some of the instructions on how to play Inform Games."	a number
"You can also check your inventory."	--
"Look around in the living room. See anything worth inspecting?"	--
"Do an action. Open things, sit on things, go north or whatever direction you can possibly go."	--

Table of Front Door
hint	used
"You're not supposed to open that door. That door will end your game."	a number
"Do you want to leave already?"	--

Table of Back Door
hint	used
"Something sharp can cut the ropes."	a number
"Have you checked the kitchen yet?"	--
"If you got the key from the living room, you can get the knife next."	--

Table of Endless Stairs
hint	used
"This place is cursed by an unknown entity and refuses to let you pass until you find a new hat to wear."	a number
"Don't ask me why you need to. Spirits are very judgemental around here."	--

Table of Hats
hint	used
"Remember which rooms you haven't checked yet."	a number
"Maybe you should relax and think more in the bedroom."	--

Table of Master Bedroom
hint	used
"You have a long way to go before opening this room."	a number

Table of Ink
hint	used
"It's good for making something readable."	a number
"The solution is nearby, probably in another room."	--
"The object you're looking for is not downstairs."	--

Table of Eternal Darkness
hint	used
"Have you read the invisible note?"	a number
"Consume the right... er, middle pills."	--
"You need light, but the switch has disappeared."	--
"Need some pills to see hidden things."	--

Table of Basement Tasks
hint	used
"Check the cellar."	a number
"You will do lots of things here and there, but first you must find the magic orb."	--
"After you found the orb, then the backyard has something else for you to do."	--

Table of Multitasking
hint	used
"Can you dig it?"	a number
"Read the coin."	--
"Those flowers need some sunlight to be happy. Have you seen any sunlight lately in a certain room?"	--
"Once you helped the flowers, do the laundry. You'll get a tasty reward if you do it."	--
"The fridge will open once your menial task is complete."	--

Table of Eggcellence
hint	used
"This egg is alive still and needs some warmth. Know a place that has lots of windows?"	a number
"Once you find the place, get packed up and go back down."	--

Table of Keybranding
hint	used
"I hope you found the item to break the trap door open."	a number

Table of Neutral Ending
hint	used
"You know what to do now."	a number
"I'm not telling you this time."	--

Table of Better Ending
hint	used
"Sorry, I'm out of hints. I can't help you anymore. You'll have to figure the rest out yourself. But don't worry, the dog might have some more hints for you later on."	a number
"Invisible green chest."	--

[When the game doesn't know you well]
Table of Misinformation
title	subtable	description
"Explanation"	--	"When you're new to IF, it's easy to type a command which the game doesn't understand. If you do, you'll get some kind of complaint. Here is a list of the most common complaints, and what to do about them."
"'You can't see any such thing.'"	--	"This is by far the most common message seen by new and experienced players alike. It means one of three things:[paragraph break]1) You tried to refer to an object using a word that the game doesn't recognise.[line break]2) The author has mentioned an object which, sadly, isn't really defined in the game, and you tried to refer to it.[line break]3) You made a spelling mistake.[paragraph break](Solution: Try using a different word -- preferably the word that the game itself used.)[line break]If you can't find a word that works, it's the author's fault -- see #2. That object probably isn't important."
"'I only understood you as far as wanting to.'"	--	"Part of your input was understood, but the game choked on some other part. This is usually caused by putting words after verbs that don't need objects... like LOOK.[paragraph break]>LOOK HORSE[paragraph break]I only understand you as far as wanting to look.[paragraph break](Solution: Rephrase your command.)[paragraph break]>EXAMINE HORSE[paragraph break]Sleek and valiant, this is the fabled horse of Rock City......"
"'You aren't holding that.'"	--	"Some verbs require that an object be in your inventory before you can perform the action on it.[paragraph break](Solution: Try to GET the object.)"
"'That's not a verb I recognise.'"	--	"The first word in a command should always be a verb. If the first word you typed is not recognized as a verb by the game, this message will appear.[paragraph break](Solution: Try a different way of stating your command.)"
"'You can only do that to something animate.'"	--	"Some verbs only work on living things. This message is shown when the object is not alive, and you try to do something like TALK to it.[paragraph break](Solution: Don't talk to rocks.)"
"'That's just scenery.'"	--	"This means that the object can be looked at, but nothing can be done with it.[paragraph break](Solution: Don't worry about it; the object isn't important.)"
"'Which do you mean, the <Object> or the <Other Object>?'"	--	"This occurs when several objects have similar names, and you typed a command which could refer to any of them.[paragraph break]Example:[paragraph break]>GET BOOK[paragraph break]Which do you mean, the red book, the green book, or the old book?[paragraph break](Solution: Type a word or words that will distiguish the object you want.)[line break]In the above case:[paragraph break]>RED[paragraph break]This will tell the game that it is the red book you want. Or, you could just retype the whole command:[paragraph break]>GET RED BOOK"

[User Styles]
Table of User Styles (continued)
style name	color
special-style-1	"#00FF00"
special-style-2	"#DC143C"

[New Command: FAQ]
Questioning is an action applying to nothing.
Understand "ask a question" and "question" as questioning.
After questioning for the first time:
	say "What do you want to ask me?";
	say line break;
	say "(Type a question or statement in the command prompt.)[line break]([bold type]Note:[roman type] Don't add the '?,' Inform doesn't allow punctuations in commands. Also this isn't like Google where you can type any question you want because that's some complicated stuff to do. There are fixed questions to this system and you may need to find them in the source text if you want to know what questions you can ask. Or don't. That might spoil the game for you. It's in the game's files if you ever need it.)"

After questioning:
	say "What do you want to ask me?"

[List of questions & statements]
[1-10]
Q1 is an action applying to nothing.
Understand "How old are you" as Q1.
Report Q1:
	choose a random row in Table 1;
	say "[answer entry]";
	say line break.

Q2 is an action applying to nothing.
Understand "What are you" as Q2.
Report Q2:
	choose a random row in Table 2;
	say "[answer entry]";
	say line break.

Q3 is an action applying to nothing.
Understand "How many licks does it take to get to the center of a Tootsie Pop" as Q3.
Report Q3:
	choose a random row in Table 3;
	say "[answer entry]";
	say line break.

Q4 is an action applying to nothing.
Understand "How is this house mysterious" as Q4.
Report Q4:
	choose a random row in Table 4;
	say "[answer entry]";
	say line break.

Q5 is an action applying to nothing.
Understand "Are you a lizard" as Q5.
Report Q5:
	choose a random row in Table 5;
	say "[answer entry]";
	say line break.

Q6 is an action applying to nothing.
Understand "Who am I really talking to" as Q6.
Report Q6:
	choose a random row in Table 6;
	say "[answer entry]";
	say line break.

Q7 is an action applying to nothing.
Understand "Why do I need to wear a hat to go upstairs" as Q7.
Report Q7:
	choose a random row in Table 7;
	say "[answer entry]";
	say line break.

Q8 is an action applying to nothing.
Understand "Am I dead" and "Am I dreaming" as Q8.
Report Q8:
	choose a random row in Table 8;
	say "[answer entry]";
	say line break.

Q9 is an action applying to nothing.
Understand "I found a misspelled word", "I found a grammar issue", "I found a bug", "I found an error", and "I found a punctuation error" as Q9.
Report Q9:
	choose a random row in Table 9;
	say "[answer entry]";
	say line break.

Q10 is an action applying to nothing.
Understand "Who am I" as Q10.
Report Q10:
	choose a random row in Table 10;
	say "[answer entry]";
	say line break.

[11-20]
Q11 is an action applying to nothing.
Understand "Why did you make a text-based game" as Q11.
Report Q11:
	choose a random row in Table 11;
	say "[answer entry]";
	say line break.

Q12 is an action applying to nothing.
Understand "Why are you such a smartass", "Why are you so sarcastic", and "Why are you so weird" as Q12.
Report Q12:
	choose a random row in Table 12;
	say "[answer entry]";
	say line break.

Q13 is an action applying to nothing.
Understand "What is the other side" as Q13.
Report Q13:
	choose a random row in Table 13;
	say "[answer entry]";
	say line break.

Q14 is an action applying to nothing.
Understand "Is this place real" and "Is this house real" as Q14.
Report Q14:
	choose a random row in Table 14;
	say "[answer entry]";
	say line break.

Q15 is an action applying to nothing.
Understand "How much wood can a woodchuck chuck if a woodchuck could chuck wood" as Q15.
Report Q15:
	choose a random row in Table 15;
	say "[answer entry]";
	say line break.

Q16 is an action applying to nothing.
Understand "Can I stream this on twitch" and "Can I record this on youtube" as Q16.
Report Q16:
	choose a random row in Table 16;
	say "[answer entry]";
	say line break.

Q17 is an action applying to nothing.
Understand "Why can't I say naughty things in this game", "Why can't I cuss", "Why can't I swear" and "Why can't I curse" as Q17.
Report Q17:
	choose a random row in Table 17;
	say "[answer entry]";
	say line break.

Q18 is an action applying to nothing.
Understand "Are you male or female" and "What is your gender" as Q18.
Report Q18:
	choose a random row in Table 18;
	say "[answer entry]";
	say line break.

Q19 is an action applying to nothing.
Understand "Tell me about the school model" as Q19.
Report Q19:
	choose a random row in Table 19;
	say "[answer entry]";
	say line break;
	now the withered school model is nowhere.

Q20 is an action applying to nothing.
Understand "Why are there so many questions" as Q20.
Report Q20:
	choose a random row in Table 20;
	say "[answer entry]";
	say line break.

[21-30]
Q21 is an action applying to nothing.
Understand "I checked the source code" and "I checked the source text" as Q21.
Report Q21:
	choose a random row in Table 21;
	say "[answer entry]";
	say line break.

Q22 is an action applying to nothing.
Understand "About the dog" and "Tell me about the dog" as Q22.
Report Q22:
	choose a random row in Table 22;
	say "[answer entry]";
	say line break.

Q23 is an action applying to nothing.
Understand "About the mouse" and "Tell me about the mouse" as Q23.
Report Q23:
	choose a random row in Table 23;
	say "[answer entry]";
	say line break.

Q24 is an action applying to nothing.
Understand "About the wyvern", "Tell me about the wyvern", "About Flahmie" and "Tell me about Flahmie" as Q24.
Report Q24:
	choose a random row in Table 24;
	say "[answer entry]";
	say line break.

Q25 is an action applying to nothing.
Understand "Why are there almost no people in this game" and "Why are there almost no people here" as Q25.
Report Q25:
	choose a random row in Table 25;
	say "[answer entry]";
	say line break.

Q26 is an action applying to nothing.
Understand "What is the point of these questions being commands" and "What is the point of these statements being commands"  as Q26.
Report Q26:
	choose a random row in Table 26;
	say "[answer entry]";
	say line break.

Q27 is an action applying to nothing.
Understand "Why do I have telepathy" and "How do I have telepathy" as Q27.
Report Q27:
	choose a random row in Table 27;
	say "[answer entry]";
	say line break.

Q28 is an action applying to nothing.
Understand "What kind of dreams do you have" and "Tell me about your dreams" as Q28.
Report Q28:
	choose a random row in Table 28;
	say "[answer entry]";
	say line break.

Q29 is an action applying to nothing.
Understand "Why does the map look so cheap", "Why is the map hard to read", "Why is the map hard to see", and "Why does the map look weird" as Q29.
Report Q29:
	choose a random row in Table 29;
	say "[answer entry]";
	say line break.

Q30 is an action applying to nothing.
Understand "The solution file is hard to understand" and "The solution file is too simple" as Q30.
Report Q30:
	choose a random row in Table 30;
	say "[answer entry]";
	say line break.

[31-40]
Q31 is an action applying to nothing.
Understand "What's 9+10" as Q31.
Report Q31:
	choose a random row in Table 31;
	say "[answer entry]";
	say line break.

Q32 is an action applying to nothing.
Understand "This sentence is false" and "This statement is false" as Q32.
Report Q32:
	choose a random row in Table 32;
	say "[answer entry]";
	say line break.

Q33 is an action applying to nothing.
Understand "Do you have siblings" as Q33.
Report Q33:
	choose a random row in Table 33;
	say "[answer entry]";
	say line break.

Q34 is an action applying to nothing.
Understand "Why are there so many curse words" and "Why are there so many bad words" as Q34.
Report Q34:
	choose a random row in Table 34;
	say "[answer entry]";
	say line break.

Q35 is an action applying to nothing.
Understand "Do you have parents" as Q35.
Report Q35:
	choose a random row in Table 35;
	say "[answer entry]";
	say line break.

Q36 is an action applying to nothing.
Understand "What is the loneliest number" as Q36.
Report Q36:
	choose a random row in Table 36;
	say "[answer entry]";
	say line break.

Q37 is an action applying to nothing.
Understand "What is your favorite season" and "What is your favorite seasons" as Q37.
Report Q37:
	choose a random row in Table 37;
	say "[answer entry]";
	say line break.

Q38 is an action applying to nothing.
Understand "How many references are in this game" as Q38.
Report Q38:
	choose a random row in Table 38;
	say "[answer entry]";
	say line break.

Q39 is an action applying to nothing.
Understand "Got any secrets" as Q39.
Report Q39:
	choose a random row in Table 39;
	say "[answer entry]";
	say line break.

Q40 is an action applying to nothing.
Understand "Why did this update take so long" as Q40.
Report Q40:
	choose a random row in Table 40;
	say "[answer entry]";
	say line break.

[41- 50]
Q41 is an action applying to nothing.
Understand "Are you a wizard" as Q41.
Report Q41:
	choose a random row in Table 41;
	say "[answer entry]";
	say line break.

Q42 is an action applying to nothing.
Understand "What is the answer to life the universe and everything" as Q42.
Report Q42:
	choose a random row in Table 42;
	say "[answer entry]";
	say line break.

Q43 is an action applying to nothing.
Understand "Stop breaking the 4th wall" and "Stop breaking the fourth wall" as Q43.
Report Q43:
	choose a random row in Table 43;
	say "[answer entry]";
	say line break.

Q44 is an action applying to nothing.
Understand "How many fingers am I holding up" as Q44.
Report Q44:
	choose a random row in Table 44;
	say "[answer entry]";
	say line break.

Q45 is an action applying to nothing.
Understand "There's no music in this game" as Q45.
Report Q45:
	choose a random row in Table 45;
	say "[answer entry]";
	say line break.

Q46 is an action applying to nothing.
Understand "Tell me a tongue twister" as Q46.
Report Q46:
	choose a random row in Table 46;
	say "[answer entry]";
	say line break.

Q47 is an action applying to nothing.
Understand "Tell me a joke" as Q47.
Report Q47:
	choose a random row in Table 47;
	say "[answer entry]";
	say line break.

Q48 is an action applying to nothing.
Understand "When's your birthday" as Q48.
Report Q48:
	choose a random row in Table 48;
	say "[answer entry]";
	say line break.

Q49 is an action applying to nothing.
Understand "How's college" as Q49.
Report Q49:
	choose a random row in Table 49;
	say "[answer entry]";
	say line break.

Q50 is an action applying to nothing.
Understand "What's with the cryptic messages in the source text" and "What's with the cryptic messages in the source code" as Q50.
Report Q50:
	choose a random row in Table 50;
	say "[answer entry]";
	say line break.

[Copy & Paste Template]
[Q51 is an action applying to nothing.
Understand "" as Q51.
Report Q51:
	choose a random row in Table 51;
	say "[answer entry]";
	say line break.]

[FAQ Table]
Answer is a kind of value.

[1-10]
Table 1 - FAQ
answer
"I'm not telling you."
"That's classified information I wish not to share."
"Honestly, I forget. Crazy right?"
"Let's just say I'm old enough to drink and gamble. Good luck figuring out the number."

Table 2 - FAQ
answer
"What do you mean by that?"
"Your worst nightmare!"
"I AM YOUR FATHER!![line break]Well... actually no, I'm not."
"The voice inside your head."
"Your mother."
"Santa Claus. Have you been good lately?"
"I'm Batman!"
"A miserable little pile of secrets."
"I AM ERROR."
"Irish, German, Puerto Rican, French Canadian.[line break]That's all I've got."
"A box of chocolates."

Table 3 - FAQ
answer
"Um... 62?"
"No clue. How about you ask that owl I met."
"I ain't Google you know."
"Try experimenting on that and tell me how it went out."

Table 4 - FAQ
answer
"It's mysterious because someone went missing 20 years ago."
"The title may sound misleading but I assure you it gets more mysterious as you go on. Just trust me on this one."
"Once you get more than halfway through the story then you'll know this house is indeed a mystery."

Table 5 - FAQ
answer
"What kind of question is that?"
"I don't know, are you? The way you type it down is awfully suspicious."
"I find it hard to answer that question because I don't know what a lizard really is. Can you teach me?"

Table 6 - FAQ
answer
"Me, of course."
"You're talking to yourself from a screen and that's just weird."
"Either the computer or someone else."
"Some famous celebrity probably, or not."

Table 7 - FAQ
answer
"Someone or something is controlling this place with dark magic and is preventing you or anyone from advancing forward. I don't know who or what, but I know how and why."
"The stairs probably did not like your fashion of choice; the stairs are very judgmental about people's clothing... and feet."

Table 8 - FAQ
answer
"You should know that answer already."
"Pinch yourself just incase."

Table 9 - FAQ
answer
"If so, then email me at once so that I can fix it. I overlook certain errors a lot. It's annoying."
"Iff yuo finde sumthing missphellt lik thsis senteence four xample, pleaze contacte mi antd teli mi I'm sucjh ay goddahmn ideoit."
"And?"
"Find my contact info in the help section of the game and then yell at me about my flaws there; Or don't. I already know I'm not perfect. Then again, who isn't."

Table 10 - FAQ
answer
"Your you and that's all that matters."
"A savior from above."
"Your the best child a mother could ask for."
"Hard to say."
"John Cena![line break](Haha you wish.)"

[11-20]
Table 11 - FAQ
answer
"Because it's the only thing they taught me in class."
"Because text-based games are the future of video game revolution. Guaranteed or your money back. (If you paid for this game you were scammed. This game is free and I don't need your money. I just wanted to make that clear.)"
"Because it's the only thing I know."
"What? Were you expecting a full fleshed 1080p, 60 fps, HD rendered game? Typical."

Table 12 - FAQ
answer
"It's the best quality of myself that I have to offer."
"I just tend to have a sense a humor that breaks many boundaries."
"Because I am."
"Why are you so chatty with these questions, huh?"

Table 13 - FAQ
answer
"Other side of what?"
"It's a place that's on another plane of existence."
"Maybe you should consult your reflection about that."
"[italic type]Dark, dead and dreary,[line break]Barren, harrowing, and cruel;[line break]Anguish evermore.[roman type]"

Table 14 - FAQ
answer
"Oh it's real alright; it's my home."
"Yes it is. It's somewhere in this country, but I'm not telling."
"Only in my head it is."

Table 15 - FAQ
answer
"If a woodchuck could chuck as much wood as a woodchuck could chuck, a woodchuck could chuck as much wood as a woodchuck could chuck."
"700 pounds of regurgitated wood. That's right."
"I'm stumped."
"He would chuck, he would, as much as he could, and chuck as much wood, as a woodchuck would if a woodchuck could chuck wood."

Table 16 - FAQ
answer
"You could but some people might find it boring. Not many people enjoy text games like they used to."
"Sure as long as you give me credit for it. And if you don't my name imprinted on the game will count as solid proof of my existence to this game made. (Also it's trademarked.)"
"You probably are already, aren't you."

Table 17 - FAQ
answer
"Because that is not acceptable behaviour."
"Let's be honest, I don't want to get sued or anything."
"If I were to let you do that then people will take this game the wrong way. I'm just playing it safe, ok?"
"The internet sometimes doesn't allow constant vulgarity in certain places, but you can still do it at the comfort of your own home."
"Well, actually, you can, but the game will not like you for it.[line break]I suggest... no, advise you leave your naughty thoughts to your head."

Table 18 - FAQ
answer
"Well what do you think?"
"I'm not checking, then I'll definitely get sued."
"Some people don't like other people assuming their gender for some reason but I'm not one of them. I'm proud to be the man I am today."
"I ain't no stinkin['] PokeyMun."

Table 19 - FAQ
answer
"I can't. It would bring back terrible memories."
"I wish I could but I can't anymore."
"How about we talk about something else."
"My sister wouldn't like to hear it, no one would."
"[italic type]gone...[roman type]"

Table 20 - FAQ
answer
"Well why do you keep asking me so many questions?"
"Wait... have you been looking at the source code?!"

[21-30]
Table 21 - FAQ
answer
"Good for you."
"You probably shouldn't; You'll get spoiled if you do."
"Don't do that, it may ruin the magic and fun of the game for you."
"Of course."

Table 22 - FAQ
answer
"He's a good boy and loves meeting new faces. Just don't tease him or anything and you should be good, too."
"At first he was just a piece of scenery just to give the place some life and was never meant be a big part of the game, but as I kept expanding the story I realize there was not enough interaction with anything living or any kind of purpose to the story. So that's when I decided to give him a bigger role rather than being just an animal you pet and look at and that's it. What's his main purpose in this story you ask? That I can't tell because that would spoil the ending of the game. You'll figure that out soon."
"I actually have a real dog who is an Australian Shepherd mix-breed, except it's a she rather than a he. Her name is Sammy. We rescued her at a local dog shelter in Colorado as a pup. She's old now, almost 15 years old, but is still full of energy despite some of her medical problems she is receiving from old age. Louie is the other dog who is a Boston Terrier and is male. He's unusually big for a Boston Terrier of his kind and has a ear infection that he got when we also rescued him off the streets of Connecticut and we call this ear his 'Nemo Ear' from the movie Finding Nemo. I put Sammy in because she's my dog and Louie is my sister's dog. This dog in this game is basically my dog's polar opposite. Come to think of it, most of this game is an exact representation of my house and life in a strange fantasy. With many inside jokes and pop culture references that you may or may not even get. I won't explain them all to you because that would take too long and might not make sense to you completely. That's all I have to say about this. I made this answer drag on way too long."

Table 23 - FAQ
answer
"I needed a female creature in my game so this would make a great substitute candidate for the role. Then again I didn't give you, the protagonist, a gender either. Whatever you are that is what you are playing as. Strange isn't it."
"Not much is known about this unnamed mouse, but she seems smarter than your average mouse and has known the owner of this house for a while now."

Table 24 - FAQ
answer
"Some people think that dragons are big and menacing mythological creatures that wreck havoc and hoard treasure. But I think not. The one I met once was smaller and was only trying to find his lost gems. Most of them mean no harm and have been known to be well trusted guardians over many things. This wyvern is here because I saw him in a dream once and I just wanted to add a little spice to this dark realm while also being a creature that may look terrifying but is more terrified of where he is now than you are of him. That and you see them in almost every video game. At least their awesome, right?"
"[italic type]What a to-do to die today, at a minute or two to two;[line break]A thing distinctly hard to say, but harder still to do.[line break]We'll beat a tattoo, at twenty to two[line break]A rat-tat-tat- tat-tat-tat- tat-tat-tattoo[line break]And the dragon will come when he hears the drum[line break]At a minute or two to two today, at a minute or two to two.[roman type]"
"He's not who you think he is, or is he. What do you think happened to him before or after? No one really knows."

Table 25 - FAQ
answer
"Because this world is too peopley to deal with."
"My introverted self just can't allow it."
"Let's face it, human beings are too unpredictable sometimes. They could be egotistical, greedy, careless, manipulative, aggressive, or anything of that sorts. We as a species are too overpowered by our own intelligence and abilities that we can bend the world to our own liking and that's sometimes not a good thing. That's why I removed... err, left them out. Hell, the dinosaurs were probably better than we were and their all dead because God said 'Ok, there's too many giant living things. Let's shrink em down with this giant space rock, turn some into birds, and add more mammals. That oughta do it. Oh, and let's cool the Earth down a few thousand degrees and into the negatives for a while. Don't worry. It'll warm up again in another million years, but our homo sapien test subjects will make that process happen much quicker and it will be all their fault.' Yeah, good plan."
"I'm not looking forward into making a bunch of people and trying to give them names, personalities, emotions, and such. I already have animals to deal with. Plus their easier. Ain't nobody got time for that!"

Table 26 - FAQ
answer
"It's just for a bit of fun. It doesn't impact the story entirely. It's more or less a bit of extra content of hidden lore and things that are not entirely explained. I can only explain so much going on that I can't answer every single thing in full detail. Some things are best left unanswered and kept a mystery. That's what makes lore, just lore and what makes game theories, just game theories."

Table 27 - FAQ
answer
"Oh right. I said I would explain that another time. Uh... you have telepathy because of, um...[line break]Advance...[line break]Scientific...[line break]Engineering?[line break]I don't know. That's all I've got."

Table 28 - FAQ
answer
"Well that's a random question to ask, one that I do have an answer for. Ok, so I have many different kinds of dreams. Most of them are lucid and reoccuring to my past. Some even foreshadow the future and cause me to have extreme deja-vu over something that I've never seen before despite thinking I have seen it before. I've been recording them in journals recently because they are too good to leave to myself and forget. And it's also something I'm just into now; it let's me release any thoughts that I choose not to disclose to anyone. I can't tell you all the dreams I've had because that would take forever to explain and type down but they are really fasinating to read and ocassionally weird too. I'm hoping to use these as inspiration for something one day. People have always said to follow your dreams and make them realities, and that's what I try to do. Thanks for asking."

Table 29 - FAQ
answer
"Somebody once mentioned that the map was hard to navigate with general compass directions like North, South, East, and West. So I put a compass next to the map. I know it's a cheap move on my part to put just a compass and put a filter on it to look old and antique and call it a day, but I was so tired from working on the base game that when it came to making a new version I was already losing energy and had to fix it with little effort as possible, which did not happen at all. In the end, I decided to leave it like that since I did not feel like making a full flesh-out map of this house, let alone 2 maps. I then took a break from this game for a while to help recollect my energy and get my creative juices flowing again and now here I was, back at this little project that I was tweaking and improving. And you know what, I learned something from all this. Being a game designer and programmer is not an easy job to do. It takes a lot of dedication and brain power to get stuff done. I mean I knew this from the very beginning, but doing all this by yourself is very stressful and tiresome. That's why I'm glad to have people out there testing out this game and giving some feedback as to what I can improve on. It gives me the extra help I need to make this game better and more polished, even if it is just a simple text-based game. A game's a game and it is not going to be perfect and flawless on its first try after all and neither will this map. If you don't like it let me know and I will try to make something better, or I'll just leave the old map here. It's all up to you."

Table 30 - FAQ
answer
"I know. Inform 7 does not generate well-made walthroughs. You can use the source text instead if you want to even if I do tell you not to, but I can't physically stop you from doing so. If you would like to make one for this game, be my guest. I would make a legit one myself but I don't have infinite amount of time on my hands."
"You can could the hint system instead, but it does contain spoiler as well."

[31-40]
Table 31 - FAQ
answer
"Seriously?"
"People still ask that?"
"I'm not answering that."

Table 32 - FAQ
answer
"Nice try."
"Indeed it is."
"I AM ERROR."
"True."
"This player is false."

Table 33 - FAQ
answer
"Yes, one. A younger sister."
"I may have answered this before, but I don't remember when I said it." 

Table 34 - FAQ
answer
"I was bored one day and looked up a bunch of them for no reason."
"Because this game needed more spice. British spice included."
"At least be happy I didn't include the REAL bad ones. You know... the racial slurs. I refuse to say those."

Table 35 - FAQ
answer
"If I didn't I would be Batman, so yes I do. Why exactly?"
"Well what do you think?"
"You know, some people don't have parents anymore or never had any when they were young and that's sad. Maybe you should ask something else before things get worse."

Table 36 - FAQ
answer
"You."
"One. It's lonely being at the top."
"A unicorn."

Table 37 - FAQ
answer
"Every season has its likes and dislikes. I like spring for its new bloom in flowers and its decent weather. Summer for its warm weather, which is my choice of weather. Fall for its colorful foliage and not so chilly weather every now and then. Winter for its beautiful and sparkling snow that gives nature and more scenic view. However, my only distaste in the fall and winter is the fact that the snow in New England can get unbearably brutal at times. Snow can hit too early, too late, or not at all. That October Storm of 2011 and Winter of 2017 was disgusting and unpredictable, and that's just to name a few. Mother Nature in Connecticut can never lay off the drinks every once in a while. I also hate being cold and prefer being warm as mentioned before. Every other season is no problem. Weather can still be unpredictable in those times but is a little more tolerable to deal with in my opinion. Just rain, wind, and sun."
"We have a saying here in this land:[paragraph break]'If you don't like the weather, wait 15 minutes.'[paragraph break]I believe that's how it goes."

Table 38 - FAQ
answer
"That I don't really know, I haven't been keeping track of how many. You can count them for me if you like."
"Enough to fill the empty hole inside your cultured heart."
"Too many. (Caution: There may not be any jojo renferences in this game. Also I lost the game.)"

Table 39 - FAQ
answer
"I have no secrets of my own, but I do hold many from my friends and family, ones of which I promised to keep confidential about."
"I cannot tell you any; they would hurt us."
"There's a secret from everybody."

Table 40 - FAQ
answer
"Making a game by yourself is not easy. Plus, once you have a finished product that's playable you end up taking a long break from it."
"I may need some extra help. Doing everything yourself is tiresome. When you give me feedback, you give me that extra hand I need."
"I answered this question before but in more detail."

[41-50]
Table 41 - FAQ
answer
"Yes."
"I wish."
"You're a wizard too, Harry."

Table 42 - FAQ
answer
"Read the book again."
"Check the question number."
"Bacon."
"Not algebra."
"4+2=??"

Table 43 - FAQ
answer
"No."
"No you."
"That's not a question."
"I can speak that in Spanish. 'No.'"
"Which wall is the 4th wall?"
"I didn't break the fourth wall, I broke the fifth wall."

Table 44 - FAQ
answer
"You don't have fingers."
"I can only program you as much as possible, but I can give you limbs. Too much pointless work."
"You're holding X number of fingers."

Table 45 - FAQ
answer
"You can play some music in the background if you like."
"I'm not sure if this program is capable of background music, but it is capable of sound effects. I just don't use them because of legal copyright issues. I'm just playing it safe."
"Who needs music when you've got class."

Table 46 - FAQ
answer
"http://www.tongue-twister.net/en.htm"
"Peter Piper picked a peck of pickled peppers.[line break]A peck of pickled peppers Peter Piper picked.[line break]If Peter Piper picked a peck of pickled peppers,[line break]Where's the peck of pickled peppers Peter Piper picked?"
"I wish to wish the wish you wish to wish, but if you wish the wish the witch wishes, I won't wish the wish you wish to wish."
"I scream, you scream, we all scream for ice cream!"
"When you write copy you have the right to copyright the copy you write..."
"How much ground would a groundhog hog, if a groundhog could hog ground? A groundhog would hog all the ground he could hog, if a groundhog could hog ground."
"I was born on a pirate ship.[line break][italic type](Say it while holding your tongue.)[roman type]"
"If you understand, say 'understand'.[line break]If you don't understand, say 'don't understand'.[line break]But if you understand and say 'don't understand'.[line break]how do I understand that you understand. Understand!?"
"Truly rural, truly rural, truly rural, ..."
"How much myrtle would a wood turtle hurdle if a wood turtle could hurdle myrtle?[line break]A wood turtle would hurdle as much myrtle as a wood turtle could hurdle if a wood turtle could hurdle myrtle."
"IF IF = THEN THEN THEN = ELSE ELSE ELSE = IF;"
"Fuzzy Wuzzy was a bear,[line break]Fuzzy Wuzzy had no hair,[line break]Fuzzy Wuzzy wasn't very fuzzy,[line break]was he?"
"[bold type]If Dr. Seuss Were a Technical Writer.....[roman type][paragraph break]Here's an easy game to play.[line break]Here's an easy thing to say:[paragraph break]If a packet hits a pocket on a socket on a port,[line break]And the bus is interrupted as a very last resort,[line break]And the address of the memory makes your floppy disk abort, [line break]Then the socket packet pocket has an error to report![paragraph break]If your cursor finds a menu item followed by a dash,[line break]And the double-clicking icon puts your window in the trash,[line break]And your data is corrupted 'cause the index doesn't hash,[line break]then your situation's hopeless, and your system's gonna crash![paragraph break]You can't say this? What a shame, sir![line break]We'll find you another game, sir.[paragraph break]If the label on the cable on the table at your house,[line break]Says the network is connected to the button on your mouse,[line break]But your packets want to tunnel on another protocol,[line break]That's repeatedly rejected by the printer down the hall,[line break]And your screen is all distorted by the side effects of gauss,[line break]So your icons in the window are as wavy as a souse,[line break]Then you may as well reboot and go out with a bang,[line break][']Cause as sure as I'm a poet, the sucker's gonna hang![paragraph break]When the copy of your floppy's getting sloppy on the disk,[line break]And the microcode instructions cause unnecessary risk,[line break]Then you have to flash your memory and you'll want to ram your rom.[line break]Quickly turn off the computer and be sure to tell your mom![paragraph break][italic type](from the Unix fortune database, attributed to DementDJ@ccip.perkin-elmer.com in the rec.humor.funny newsgroup)[roman type]"
"She sells seashells on the seashore. The seashells she sells are seashore seashells."
"I wish to wish, I dream to dream, I try to try, and I live to live, and I'd die to die, and I cry to cry but I dont know why."
"Freddy is ready to roast red roaches.[line break]Ready for Freddy's roasted red roaches?"
"The sixth sick sheik's sixth sheep 's sick.[paragraph break](Good luck. This one is the hardest.)"
"Which wristwatch is a Swiss wristwatch?"
"If a Fudpucker could puck fud, how much fud could a Fudpucker puck if a Fudpucker could puck fud.[paragraph break](Say it right or I'm getting the soap.)"
"The big black bug bit a big black bear and bled blue blood, but the big black bear bit the big black bug back, and the big black bug bled black blood."

Table 47 - FAQ
answer
"Why did the chicken cross the road?[line break]He's dead."
"Knock-Knock.[line break]Whose there?[line break]The internet police.[line break]Crap."
"How do you make a pool table laugh?[line break]You tickle it's balls."
"Yo mama is so... wait, no. That's enough."
"Guess what my favorite planet is.[line break]Hint: #7"
"When California has an earthquake and it hits us, I blame them and say 'It's all their fault.'"
"That's what I said."
"Why is 6 afraid of 7?"
"I invented a new word: Plagiarism!"
"I say chemistry jokes at the dinner table periodically."
"Knock! Knock![line break]Who’s there?[line break]Control Freak.[line break]Con…[line break]OK, now you say, 'Control Freak who?'”
"Heard of the new restaurant called Karma? Of course you haven't, you've got what you derserved."
"So a guy walks into a bar...[line break]Blah blah blah...[line break]you have a long face."
"Don't trust atoms. They make up everything. They are also negative sometimes."
"Why can’t you explain puns to kleptomaniacs?[line break]They always take things literally AKA almost everyone on the internet."
"What’s the different between a cat and a comma?[paragraph break]A cat has claws at the end of paws; A comma is a pause at the end of a clause."
"What's funnier than 24?"
"67, 68, 6...[line break]70..."
"What's black and blue and has red all over? (I'm not answering this one.)"
"What do you call a rooster. COCK!"
"I poured my root beer into a square glass and now it's just beer. Sad."
"Is your refrigerator running? Good."
"Do you like bananas? K."

Table 48 - FAQ
answer
"February 31st."
"It maybe too soon for that."
"Birthday's only make me feel old and no one wants that reminder when their 65."
"Check back in the next century or so."

Table 49 - FAQ
answer
"It's college."
"Fine."
"It's good, but it can be overbearing sometimes."
"[bold type]Point of advice:[roman type] Don't take out student loans. Unless you really need to, don't take out more than you can pay back."
"If you're in college or have been to college, you know how it feels brother (or sister)."

Table 50 - FAQ
answer
"What cryptic messages?"
"You weren't suppose to find those."
"I forgot to get rid of them. Oh well, it's too late for that now."
"Bad things happens but we must learn to forgive and forget."

[Copy & Paste Template]
[Table 51 - FAQ
answer]

Section 1.0 - The First Floor

[Living Room - "Happiness dies when you get older. It's a fact."]
The Living Room is a room. The description of the Living Room is "The first room you enter is the living room. It is nothing more than your standard living room. In here are two couches, one chair, a flight of staircases to go up to, a table with a chest on it, and an old television, and also the front door you came in from but that doesn't matter anymore. The place looks beautiful."

The large couch, a small couch, a white chair, a large window, an old television and a coffee table are in the Living Room.
The small chest is on the coffee table. A small chest is a closed openable container. The small chest is fixed in place.
A blue key is in the small chest.
The old television is scenery.
Understand "couch 1" and "sofa 1" as large couch. Understand "couch 2" and "sofa 2" as small couch.

The description of the coffee table is "An simple table to place your coffee and household items on. Looks sturdy."
The description of the large couch is "A red couch that can fit three or more people at once (mostly three, it gets too crowded)."
The description of the small couch is " A red couch that can fit two or more people at once. It's slightly inferior to its larger brother."
The description of the white chair is "A cushioned chair."
The description of the old television is "An old box TV. It's broken though so you can't turn it on and watch 'Game of Thrones.' How disappointing."
The description of the blue key is "A blue key that unlocks something small and clear."
The description of the large window is "Through the window you see your car you drove to get here and some bushes that are alongside the edge of the house. The trees in the distance cover up most of the view but are still pretty to look at."

Instead of switching on the old television:
	say "I said the TV was broken. Don't even try to turn it on. It's hopeless."
After touching the old television:
	say "What's that going to solve?"
After touching the old television for the tenth time:
	record "Procrastination" as an ending;
	end the story saying "The TV somehow managed to turn on after poking it uncontrollably. Are you a wizard or something? Anyways, you decided to sit on the couch and binge watch 'Stranger Things' instead of doing you job. You never left that spot and died of malnutrition. Maybe next time you should think twice before trying to do the inevitable and delaying the other, and also go outside and enjoy the sunlight."

Test tv with "turn on tv / touch tv / touch tv / touch tv / touch tv / touch tv / touch tv / touch tv / touch tv / touch tv / touch tv".

Section 1.1 - The Exit Door

[Exit Door - "She sometimes wish she wasn't a parent"]
The front door is a locked door. It is south of the Living Room. Through it is the Coward Ending.
The exit key unlocks the front door.

After examining the front door the first time:
	say "You can't leave now you just got here."
After examining the front door the second time:
	say "Are you saying you don't want to do this anymore?"
After examining the front door the third time:
	say "Can't you just at least look around before leaving?"
After examining the front door the fourth time:
	say "Look, I know this place may looking intimidating but I assure you it's not that bad. Trust me."
After examining the front door the fifth time:
	say "Please?"
After examining the front door the sixth time:
	say "..."
After examining the front door the seventh time:
	say "Fine! I'll let you leave, but only because I just want you to stop staring at the door like a sad puppy. The key is on that table there. Just take it and leave.";
	now the exit key is on the coffee table.
After entering the front door:
	record "Coward Ending" as an ending;
	end the story saying "Wuss."
Instead of going south from the Living Room:
	say "You can't go south."
[Editor's Note: Going south would not end the game so the option in this room was disabled. Type "enter door" instead.]

Instead of examining the front door when the player is carrying the dog:
	say "No turning back now."

Test door with "x door / x door / x door / x door / x door / x door / x door / take key / unlock door with key / enter door".

[Dining Room - "People tell me I need to gain weight. I can't, my body just can't."]
The Dining Room is east of the Living Room. The description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks."

5 chairs are in the Dining Room.
The large table, some knick-knacks, some fancy china, an unknown bottle, and a PC are in the Dining Room.
The strange meal is on the large table.
The strange meal is edible.
The PC is a switched off device. The PC is fixed in place.
The knick-knacks and fancy china are scenery.
The unknown bottle is a closed container. It is fixed in place.
Understand "food" and "grub" as strange meal. Understand "Windows Vista", "Windows Piss-ta", and "desktop" as PC.
Understand "knick knacks" and "dusty crap" as knick-knacks.
Understand "dishes" and "fine china" as fancy china.
Understand "bottle of Mercury" and "Mercury" as unknown bottle.

The description of the PC is "An old Windows Vista computer...[line break]Eww Vista?! Who uses Vista? Whatever, their loss."
The description of the strange meal is "A randomly served dish that was left here. It looks tasty but I'd rather not eat it. Who knows how long that's been there for."
The description of the knick-knacks are "Dusty, cheap, and gaudy."
The description of the fancy china is "'Made in Taiwan.' Liars."
The description of the unknown bottle is "The bottle's label says 'Mercury' on it. From the looks of the droplet, that acts as the cap, it seems to have been used."

After examining the unknown bottle:
	now the printed name of the unknown bottle is "bottle of Mercury".
Instead of opening the unknown bottle:
	say "My mother's uncle had a bottle of Mercury in a tube once and she used to play around with it. That was way back when people didn't know Mercury was posionous to us of course, but now we know and you should not open it. Alright?";
	now the printed name of the unknown bottle is "bottle of Mercury".
Instead of drinking the unknown bottle:
	say "Do you want to die?"
Instead of switching on the PC:
	say "There's no time for that right now. What were you gonna search for anyways, sicko?"
Before taking the strange meal:
	say "Are you sure about this? This could be over the expiration date."
Before eating the strange meal:
	say "Eat this abomination?";
	if player consents:
		record "Five Second Kill" as an ending;
		end the story saying "You ate the meal and died from food poisoning soon afterwards. Nice job genius.";
	otherwise:
		stop the action.
After tasting the strange meal:
	say "It stings your tongue a bit."

Test food with "x meal / take meal / eat meal / y".

[Kitchen - "Why can't he just have some self control?"]
The Kitchen is north of the Dining Room. The description of the Kitchen is "Ah yes. The place where all the food is hoarded... I mean stored for winter. Wait, that doesn't make any sense; animals don't live in people homes, or do they? Either way there must be something useful in here."

The dog, a duel sink, a sturdy stool, a stinkbug, a ceiling lamp, the counter-top, a glass cutting board, a coffee machine, a drinking glass, the window sill, and a cupboard are in the Kitchen.
The stinkbug is an animal.
The duel sink, ceiling lamp, counter-top, coffee machine, window sill, drinking glass, and glass cutting board are scenery.
The cupboard is a transparent closed locked openable container. The cupboard is fixed in place. 
The butcher's knife is in the cupboard. The blue key unlocks the cupboard.
Understand "Australian Shepherd", "mutt", "hound", "canine", "k9", "pup", and "pooch" as dog.
Understand "bug" and "insect" as stinkbug.

The description of the dog is "The mutt is [state] and sleeping soundly."
The description of the duel sink is "Incase you're thirsty and need a quick drink."
The description of the cupboard is "A small cupboard. Perfect for encasing small figurines, like toy Indians and soldiers."
The description of the butcher's knife is "It'd be careful when handling that thing if I were you."
The description of the sturdy stool is "This is a very sturdy stool."
The description of the coffee machine is "Coffee: I drink it to forgot but I always remember."
The description of the stinkbug is "Connecticut's cockroaches. If one was to kill it, it would unleash its deadly radiation and permeate throughout the room. Your sister would always freak out when one was in her room even though they did absolutely nothing but fly around and sound like a helicopter and she would ask you kindly to throw it outside and you did. (So many stinkbugs.)"

After switching on the duel sink:
	say "The water flows from the faucet. You should turn it off before leaving so you don't waste the water bill, that is if this place is still owned by someone.";
	now water 2 is part of the duel sink.
After switching off the duel sink:
	say "The water stops flowing from the faucet.";
	now water 2 is nowhere.
Instead of taking the stinkbug for the first time:
	say "You tried to grab it but it flies off somewhere else. Must be one of those frisky kinds."
Instead of taking the stinkbug:
	say "It flies off to another location."
Before attacking the stinkbug:
	say "Kill this pest? (Don't you freakin['] dare!)";
	if player consents:
		record "This Death Stinks" as an ending;
		end the story saying "A heaping amount of Plutonium gas came out of the bug, causing you suffocate and get radiation poisoning at the same time. All those times tossing 53,597 stinkbugs out the window and yet you still forgot not to squish one. Bravo.";
	otherwise:
		stop the action.
After smelling the stinkbug:
	say "Yeck! It's so wretched."

Test kick with "kick dog / kick dog / kick dog / kick dog".

[The stinkbugs movement - "No matter how hard I try I can't please them enough."]
Every turn when examining the stinkbug:
	say "The stinkbug is on the [one of]cupboard[or]duel sink[or]ceiling lamp[or]counter-top[or]drinking glass[or]glass cutting board[or]window sill[or]coffee machine[at random]."

Every turn when taking the stinkbug:
	say "Now it's on the [one of]cupboard[or]duel sink[or]ceiling lamp[or]counter-top[or]drinking glass[or]glass cutting board[or]window sill[or]coffee machine[at random]."

Test bug with " x bug / take bug / x bug / take bug."

[Mudroom - "I've had enough of her stupid sarcasm."]
The Mudroom is north of the Kitchen. The description of the Mudroom is "This is where people place their shoes to prevent dirt from entering the house, hence the name 'mudroom,' and is a convenient place for storing some tools. The room is filled with plants and gardening supplies, must be because of all the windows. The light feels good on the face."

9 windows are in the Mudroom.
A broom-closet, some plants, some gardening tools, and a shoe rack is in the Mudroom.
The broom-closet is a locked enterable container. The broom-closet is scenery.
The plants and gardening tools are scenery.
The shoe rack is a supporter.
The pair of shoes are on the shoe rack. It is fixed in place.
The printed name of the broom-closet is "broom closet".
Understand "broom closet" as broom-closet.
Understand "gardening supplies" as gardening tools.

The description of the windows are "Through the windows you can see the backyard. The door to the yard is to the right of you."
The description of the shoe rack is "A rack used to hold shoes, but all the shoes are old and dirty. Best to leave them alone."
The description of the pair of shoes are "They don't comfortable to wear. That's too bad. You needed a new pair of shoes, but these won't do."

Instead of opening the broom-closet:
	say "It's locked and also broken."
Instead of entering the broom-closet:
	say "Remember what happened to Stanley? Do you want to end up like him as well?";
	if player consents, say "Suit yourself, player 2.";
	otherwise say "Thought so."
After smelling the pair of shoes:
	say "Why would you do that? They smell awful, you weirdo."

Section 1.2 - The Back Door

[Back Door - "She thinks I was the favorite child. She's wrong."]
The back door is a locked door. It is outside of the Mudroom and inside of the Backyard. The butcher's knife unlocks the back door.
The ropes are part of the back door.

The description of the back door is "This door leads to the backyard. A bunch of rope is keeping the door barricaded. They look durable, but are worn out."

After unlocking the back door with the butcher's knife when the dog is tame:
	say "The rope falls down to the floor with a thud.";
	now the dog is calm;
	now the ropes are nowhere;
	now the description of the dog is "The dog is [state] and awake. It seems to not care about you trespassing the place.";
	now the description of the back door is "This door leads to the backyard. The chains are gone now.";
	now the description of the Kitchen is "As you walk back into the kitchen you almost trip over the dog. The fact of this dog always being near the doorway reminds you of your pet dog Louie. He would always block the doorway to the kitchen because everyone in the house would be hanging out there and he would follow you around for affection. This may not be the last time this happens to you."

After unlocking the back door with the butcher's knife when the dog is startled:
	say "The rope falls down to the floor with a thud.";
	now the dog is skiddish;
	now the ropes are nowhere;
	now the description of the dog is "The dog looks at you all [state] because of your action earlier. Perhaps you should apologize sooner or later so you don't feel guilty about yourself.";
	now the description of the back door is "This door leads to the backyard. The chains are gone now.";
	now the description of the Kitchen is "As you walk back into the kitchen you almost trip over the dog. The fact of this dog always being near the doorway reminds you of your pet dog Louie. He would always block the doorway to the kitchen because everyone in the house would be hanging out there and he would follow you around for affection. This may not be the last time this happens to you.".

[Redemption 1 - "I feel like I'm being rejected by every company."]
After saying sorry to the dog when the dog is startled:
	say "Good! Don't ever do that again.";
	now the dog is tame;
	now the description of the dog is "The dog is [state]. He sits there feeling grateful for your apology."

[Backyard - "Just when I know what to do they persuade me into other careers."]
The description of the Backyard is "The backyard is wide and lush with green grass. It's been bordered with a wooden fence to prevent things for entering or leaving (like you). There's not much to do here besides looks at the clouds, listening to the birds, and enjoying nature at its finest."

A dirt pile, the grass, a wooden fence, some clouds, the blue sky and some birds is in the Backyard.
The grass, blue sky, and clouds are scenery.
The birds are fixed in place.
Understand "soil", "mud", and "earth" as dirt.

The description of the dirt pile is "It's dirt. Nuff said."
The description of the wooden fence is "The fence is blocking your way to the woods in the back. Not that you needed to go in there either way. Unless you want to risk yourself getting mauled by a pack of wild coyotes."
The description of the blue sky is "Why is it blue again?"

After listening to the backyard:
	if the birds are in the backyard, say "You hear the sound's of nature.";
	otherwise say "It's quiet outside. No birds are chirping, no wind is blowing, it's all silent."

[Hallway - "I have a tendency to make piss-poor decisions."]
The Hallway is west of the Kitchen and north of the Living Room. The description of the Hallway is "On the hallway walls are a bunch of small picture frames with pictures of people who you don't recognize. Some shelves and drawers can be found here and there with books and other little trinkets on them. This room is mainly for easier transportation between other rooms. Other than that this is just a nice scenic route to take so carry on."

The drawers, the books, the photos, the trinkets, and the shelves are scenery in the Hallway.
Understand "pictures" and "photographs" as photos.

The description of the shelves are "Worn out and made of wood. Very dusty as well. [italic type]*cough*[roman type]".
The description of the books are "Nothing peaks your interest. Most of them are about gardening, hiking, and old folk tales."
The description of the drawers are "The drawers are glued together; the books are too. Who does that? Someone must not want you tampering with their stuff."
The description of the trinkets are "More dusty crap. [italic type]*cough*[roman type]".
The description of the photos is "Various faces of unrelated family members. One however catches your eye. A small boy in a vest. You've never seen this boy before and yet he looks familiar to you."

[Bathroom - "She works too much."]
The Bathroom is north of the Hallway. The description of the Bathroom is "A place to bathe and do your business in privacy. The tub, toilet, and sink look clean despite not being used in years."

The medicine cabinet, a fancy toilet, a bathtub, and a small sink are in the Bathroom.
The small sink is scenery. 
After entering the fancy toilet: 
	say "Great...";
	wait for any key;
	say "but you don't need to go."
The bathtub is a enterable supporter. 
After entering the bathtub: 
	say "A perfect fit...";
	wait for any key;
	say "but you're already clean."
The medicine cabinet is a opaque closed openable container. A bottle of red pills and a bottle of blue pills are in the medicine cabinet. The medicine cabinet is fixed in place.
The bottle of red pills and bottle of blue pills are edible.
Understand "pills 1" and "red pills" as bottle of red pills. Understand "pills 3" and "blue pills" as bottle of blue pills. Understand "tub" as bathtub.

The description of the small sink is "A small ornate sink."
The description of the fancy toilet is "The oval office."
The description of the bathtub is "For when you need to wash that filth away."
The description of the medicine cabinet is "This cabinet stores medicine and other little bathroom tools like toothbrushes. It also has a mirror for you to gaze into, even though it's a bit unclear from all the smudge marks."
The description of the bottle of red pills is "A bottle with red pills in it. You don't know what they do. Perhaps these two bottles are a choice. Choose wisely."
The description of the bottle of blue pills is "A bottle with blue pills in it. You don't know what they do. Perhaps these two bottles are a choice. Choose wisely."

After switching on the small sink:
	say "The sink is now on.";
	now water 3 is part of the small sink.
After switching on the small sink:
	say "The sink is now off.";
	now water 3 is nowhere.
After eating the bottle of red pills:
	record "Can't Wake Up" as an ending;
	end the story saying "After gulping down one of the pills you fell asleep and never woke. Perhaps that wasn't the right choice."
After eating the bottle of blue pills:
	record "Wake Me Up Inside" as an ending;
	end the story saying "After swallowing down one of the pills you woke up in your dream and realized it was just a dream, or was it?"

[Bedroom - "People tell me to see the positives in things. Those people are wrong."]
The Bedroom is west of the Hallway. The description of the Bedroom is "This where most of the actions happens (that's what she said). You can sleep here, watch some television, or just relax and wind down as time flies by. But there's no time for that, you have a mission to still fulfill. Find some clues if you can. There's a clock here but it's broken so that won't help."

The small television, a queen-size bed, a closet, an antique clock, and a wardrobe is in the Bedroom.
The small television is fixed in place. 
After entering the bed: 
	say "Nice and cozy."
The antique clock is scenery.
The closet is an openable enterable closed container. It is fixed in place.
The wardrobe is an openable closed container. It is fixed in place. A red pinned hat is in the wardrobe. The red pinned hat is wearable.
Understand "armoire" as wardrobe.

The description of the small television is "This one is smaller than the one in the living room but unlike that one this one turns on."
The description of the queen-size bed is " A bed fit for two people. When you were little, you remembered climbing into your parents bed when you had nightmares."
The description of the antique clock is "An old clock. The time is off by 6 hours."
The description of the closet is "Just a closet. Nothing special."
The description of the wardrobe is "A portable closet that hangs clothes and possibly leads to Narnia, if you look inside."
The description of the red pinned hat is "A hat with a pin that says 'The stairway to heaven is open.' It glitters with an unusual glow."

After entering the closet for the first time:
	say "Annnnnnnnd...";
	wait for any key;
	say "it's empty."
After entering the closet:
	say "Nope. Still empty."
After entering the closet for the fifth time:
	say "What, you think something is going to happen if you keep repeatedly going through the closet and get another bad ending or cheesy death so you can tell you're friends, '[italic type]Oh! Did you get the broom closet ending? The broom closet ending was my favorite.[roman type]' Sorry, you're thinking of the wrong game. Come to think of it I believe the actual broom closet in the mudroom is locked and broken. Anyways, get out of that closet.";
	now the description of the broom-closet is "Yep, it's broken alright and also locked.";
	now the description of the closet is "Seriously, stop going in and out of that closet. Your achieving nothing doing this.";
	now the inverted closet is in the Inverted Bedroom.
After entering the closet for the sixth time:
	say "Seriously, stop this."
After entering the closet for the seventh time:
	say "Stop."
After entering the closet for the eighth time:
	say "Come on."
After entering the closet for the ninth time:
	say "Knock it off!"
After entering the closet for the tenth time:
	say "..."
After entering the closet for the eleventh time:
	say "!!!"
After entering the closet for the 12th time:
	say "[bold type]ENOUGH!!![roman type]";
	say line break;
After entering the closet for the 13th time:
	say "You know what I'll do. I'll just end your game here. Yeah, that's right; I can do that.";
	wait for any key;
	say "Watch me!";
	fake command;
	say paragraph break;
	say "  *** Game Over. ***";
	say paragraph break;
	say "Would you like to RESTART, RESTORE a saved game, QUIT or UNDO the last command?"
After entering the closet for the 14th time:
	say "..."
After entering the closet for the 15th time:
	say "I bet your thought your game was over huh? Are you mad about it?";
	if player consents, say "Well maybe you should stop going into the closet over and over again.";
	otherwise say "No! So you didn't fall for my trap?"
After entering the closet for the 16th time:
	say "...";
	wait for any key;
	say "I hate you so much right now."
After entering the closet for the 17th time:
	say "Why won't you just let me have fun for once?"
After entering the closet for the 18th time:
	say "[italic type]groan[roman type]";
	say line break;
After entering the closet for the 19th time:
	say "..."
After entering the closet for the 20th time:
	say "[bold type]STOOOOOOOOOOOOP!!!![roman type]";
	say paragraph break;
	wait for any key;
	say "That's it! I'm done, I'm just... done.";
	wait for any key;
	say "You win, OK?";
	wait for any key;
	say "I don't care anymore. I'll just wait here until you decide to stop lallygagging and make some better use of your time.";
	wait for any key;
	say "Just... please.";
	wait for any key;
	say "Get out of that damn closet soon.";
	now the description of the closet is "Your new home apparently."
After entering the closet more than 20 times:
	say "..."
After entering the closet for the 50th time:
	say "You know what, I just realized the fact that after every death and game over you've obtained throughout this entire game...";
	wait for any key;
	say "doesn't even matter.";
	wait for any key;
	say "In fact, death doesn't even matter to you. Why?";
	wait for any key;
	say "Because you can just simply look at your watch and say 'RESTART' or 'UNDO' and [italic type]boom[roman type] your back where you left off.";
	wait for any key;
	say "As if nothing bad ever happened to you.";
	wait for any key;
	say "Your lucky player. Your lucky that you are always given another chance to try again.";
	wait for any key;
	say "To right the wrong. To fix the broken. To start anew.";
	wait for any key;
	say "Many people wish they had that power in real life.";
	wait for any key;
	say "To fix the mistakes that which they wished they didn't make in the first place.";
	wait for any key;
	say "But you... player, have that power.";
	wait for any key;
	say "You should be grateful that you have this wonderful gift of rewinding time.";
	wait for any key;
	say "I don't care if you keep going in and out this closet still, that's your choice whether you choose to stop or not.";
	wait for any key;
	say "You have freewill to do whatever you want and you should do what you think is best for you.";
	wait for any key;
	say "...";
	wait for any key;
	say "I'll let go now.";
	wait for any key;
	say "But just remember...";
	fake command 2;
	say "Always."
After switching on the small television:
	say "The TV only shows static. Must have poor signal, just like the college you attended. You'll never miss that."
After switching off the small television:
	say "The TV cuts to black."
After wearing the red pinned hat:
	say "As you put on the hat, a strange noise is made. It came from the Living Room."
After listening to the bedroom:
	say "The clock is ticking each passing second."

Test closet with "enter closet / exit".

[Prevent wearing two hats at once - "I'm more of an optimistic pessimist."]
Instead of wearing the red pinned hat:
	if the player is wearing the black cap, say "You'll need to take off your other hat first.";
	otherwise continue the action.

Instead of wearing the black cap:
	if the player is wearing the red pinned hat, say "You'll need to take off your other hat first.";
	otherwise continue the action.

Section 1.25 - _____________ Room

[Hidden Secret - "I'd rather not tell."]
The old shed is in the Backyard. It is fixed in place.
The shed door is a closed locked openable enterable container. The shed door is part of the old shed.
The keypad is a device. The keypad is part of the shed door.

The description of the old shed is "A small shed that holds all of the garden tools inside. The door appears to be locked with some sort of keypad."
The description of the shed door is "The door is pretty big and wide."

After switching on the keypad:
	now the player is in the Matrix;
	clear only the main screen;
	now stage is passcode.

The Matrix is a room. The printed name of the Matrix is "Keypad".

Data is a kind of value. The data are passcode, return, and complete.

Password is a scene.
Password begins when the location is the Matrix.
Password ends when stage is complete.
Stage is data that varies.

When Password begins:
	now stage is passcode.

Every turn during Password:
	if stage is passcode:
		now current question is "What's the passcode?";
		now current prompt is ">";
		ask an open question, in number mode.

A number question rule (this is the code rule):
	if password is happening and stage is passcode:
		if number understood is 795061:
			say "[first custom style]Access Approved!";
			now shed door is unlocked;
			now the keypad is activated;
			now the player is in the Backyard;
			now stage is complete;
			exit;
		otherwise:
			say "[second custom style]Access Denied!";
			now keypad is switched off;
			now the player is in the Backyard;
			now stage is return.

[To prevent being trapped in the empty void - "I like animals better than people. At least they don't judge."]
Instead of switching off the keypad when the keypad is activated:
	say "The keypad has been activated. It cannot shut off."

Section 1.3 - The Upstairs

[Prevent going upstairs without an equipped item - "Elementary was a nightmare."]
Instead of going up from the Living Room: 
	if the player is wearing the red pinned hat, continue the action;
	otherwise say "A powerful force is blocking you from going upstairs. A note on the stair railing says, 'You'll need special headwear to head up.'"

Test hat with "take off cap / put on hat".

Section 2.0 - The Second Floor

[Second Floor Room - "They always told me I was 'special,' but am I really?"]
The Second Floor is up from the Living Room. The description of the Second Floor is "A small room that corners into four doorways. North is the bathroom, East is the Master Bedroom (which is locked so you can't go that way yet), West is the Guest Bedroom, and South is back down the stairs. Choose a destination. (Note: Going south leads nowhere, type 'down' instead.)"

[Upstairs Bathroom - "He doesn't take criticism well."]
The Upstairs Bathroom is north of the Second Floor. The description of the Upstairs Bathroom is "This bathroom is smaller than the one downstairs. It contains no bathtub but does have a toilet and sink at least. Most of the room is empty besides this mirror hanging above the sink, which is making a weird glow on its reflective surface."

The small toilet, an upstairs window, and a small upstairs sink are in the Upstairs Bathroom.
A ink bottle is on the small toilet.
After entering the small toilet: 
	say "Great...";
	wait for any key;
	say "but you don't need to go."
The small upstairs sink is scenery.

The description of the small toilet is "This toilet is similar to the one downstairs but smaller."
The description of the small upstairs sink is "Same bathroom sink but upstairs. That's all folks."
The description of the ink bottle is "On the bottle is inscribed, 'For making invisible writing visible again.' Perhaps we can use this on the note in the other room."
The description of the upstairs window is "Through the window you can see the entire backyard from a higher viewpoint. You can even see over the fence where the woods reside."

After switching on the small upstairs sink:
	say "The sink is now on.";
	now water 4 is part of the small upstairs sink.
After switching off the small upstairs sink:
	say "The sink is now off.";
	now water 4 is nowhere.
Instead of touching the ink bottle:
	say "I wouldn't, lest you want to end up like messy Joey."
Instead of drinking the ink bottle:
	say "I heard a story about someone who did this.";
	wait for any key;
	say "There once was a nameless adventurer who visited a haunted mansion.";
	wait for any key;
	say "He entered this haunted manor and was asked by a ghost to traverse a thousand rooms for some unexplained reason.";
	wait for any key;
	say "He was looking for a romantic getaway at first but instead found himself lost in this never-ending labyrinth of a house.";
	wait for any key;
	say "He decided write notes as breadcrumbs to prove that he was making progress but later ended up running out of food and water, drank his ink after getting too thirsty, found some unlabeled wine, drank it, and died shortly afterwards. He didn't even get halfway there.";
	wait for any key;
	say "He also said his death was very romantic. Of course, this nameless man probably did not know what real romance was even if it hit him.";
	wait for any key;
	say "What do I mean by all this?";
	wait for any key;
	say "Well, the moral of the story is 'Don't drink ink.";
	wait for any key;
	say "And also don't venture into haunted mansions. Because you will die and no one will possibly remember who you were."

Test ink with "take ink / s / w / use ink on note".

[Guest Bedroom - "Life sucks sometimes but I don't believe in suicide being a solution."]
The Guest Bedroom is west of the Second Floor. The description of the Guest Bedroom is "A room used when guests visit. Of course, guests can also sleep in the downstairs bedroom, living room, or where ever there's a couch or bed to sleep on. There's even a rug for a softer luxury. How sweet."

The guest bed, a desk, a small chair, a bureau, and a soft rug are in the Guest Bedroom.
After entering the guest bed:
	say "It's as comfy as the other bed and yet you still don't feel sleepy."
On the desk is the yellow note. It is fixed in place.
The bureau is a supporter. On the bureau is a pot of flowers.
A bureau drawer is part of the bureau. The bureau drawer is a closed openable container.
The soft rug is scenery.
Understand "dresser" as bureau. Understand "dresser drawer" as bureau drawer.

The description of the guest bed is "A small bed fit for one person and one person only."
The description of the desk is "Perfect of writing and doing work on, like homework. You always hated doing homework for school."
The description of the small chair is "A nice wooden chair to sit in while doing work at your desk."
The description of the bureau is "Used to store clothing in. This reminds you of times you went panty raiding with your friends in high school. You sick pervert you."
The description of the soft rug is "Good thing you took your shoes off before you came into the house. You would have gotten dirt all over it. It feels nice on your feet."
The description of the pot of flowers is "Flowers: they make the room look alive. These flowers, however, are lacking sunlight and need a spot on the east side where the light beckons."

Instead of opening the bureau drawer:
	say "It's locked tight. Good on them."
After smelling the pot of flowers:
	say "Mmm... what a nice aroma it gives off."
After taking the pot of flowers:
	say "This could be helpful one day."
After touching the soft rug:
	say "So soft you could sleep on it."

[Prevent reading note unless player has key item - "We never saw eye to eye."]
Instead of examining the yellow note:
	say "There's nothing written on this note."

After using the ink bottle on the yellow note:
	say "Using the ink bottle on the note revealed a hidden message. On the note reads, 'RGB. The middle one is the correct one to consume.'";
	now the bottle of green pills is in the medicine cabinet.

[Pills action - "I regret nothing."]
A bottle of green pills is an edible thing.
Understand "pills 2" and "green pills" as bottle of green pills.

The description of the bottle of green pills is "Were these pills here before?"

[Light switch action - "Some people tell me you need to be more positive. That's just creepy if overdone."]
After eating the bottle of green pills:
	say "After consuming one of the green pills, you hear a noise coming from down below.";
	now the light switch is in the Hallway; now the description of the Hallway is "On the hallway walls are a bunch of small picture frames with pictures of people who you don't recognize. Some shelves and drawers can be found here and there with books and other little trinkets on them. This room is mainly for easier transportation between other rooms. You notice that there's a switch now on the wall. Was it here before and you didn't notice it until now?"

A light switch is a device. It is fixed in place.
Understand "lights" as light switch.

Carry out switching on the light switch:
	now the Basement is lit;
	now the light switch is activated.

Instead of switching off the light switch when the light switch is activated:
	say "The switch is now stuck in its position. It cannot be turned off."

Test switch with "take green pills / eat green pills / s / turn on switch / turn off switch / down".

Section 2.1 - The Downstairs

[Prevent moving forward in the dark - "Sometimes you need to be upset. It's what makes us human."]
Instead of going south from the Basement:
	if the light switch is switched on, continue the action;
	otherwise say "You can't move anywhere until you find some sort of light source."

Instead of going west from the Basement:
	if the light switch is switched on, continue the action;
	otherwise say "You can't move anywhere until you find some sort of light source."

Section 3.0 - The Lower Floor

[Basement - "Why am I like this?"]
The Basement is down from the Hallway. The Basement is dark. The description of the Basement is "A musky place this is. There's a lot of junk down here, it must have been used for storage mostly. Kind of reminds you of your basement back home; all cluttered and full of boxes and stuff. There's only two rooms down here, one being a cellar and the other being the back room. Maybe somewhere in all this junk is something useful."

A refrigerator, a washer, a dryer, a junk pile, a circuit breaker, and a large box are in the Basement.

The refrigerator is an closed openable container. It is fixed in place.
The refrigerator can be cold. The refrigerator is cold.
The washer and dryer are a openable container. The washer and dryer are fixed in place.
The junk pile is scenery.
The circuit breaker is a switched on device. It is fixed in place.
The large box is a closed openable container. It is fixed in place.
Inside the box is a clown doll. The clown doll is fixed in place.
Understand "fridge" as refrigerator.

The description of the refrigerator is "It's a device that contains food and conserves it at a reason temperature. People would often misspell 'refrigerator' with a 'D' because everyone says fridge mostly. College was no different either with you and your peers misspelling it over and over again. In the end, you decided to not even bother trying to spell it correctly and said fridge instead. Same goes with other words like 'television as tv' and 'telephone as phone.' So many 'tele's' have been removed, am I right?"
The description of the washer is "A machine that washes."
The description of the dryer is "A machine that dries."
The description of the junk pile is "Stop looking at my junk! (And get your mind out of the gutters too!)"
The description of the circuit breaker is "This is the main power supply of the entire house. Without it, nothing will work. So don't touch it if you know what's good for ya."
The description of the large box is "A cardboard box."
The description of the clown doll is "Devil incarnate."

After opening the large box for the first time:
	say "BAH!";
	wait for any key;
	say "A clown doll jumps out of the box like a jack-in-the-box and spoops you. The fact that your biggest fear is clowns doesn't make this situation any better; especially that weird news about people going around wearing clown masks at night you heard once did not help your anxiety either.";
	say line break;
	wait for any key;
	say "And yes I said 'spoop,' problem?"
After closing the large box:
	say "Thank goodness. Let's never open that again."
After opening the large box for the second time:
	if the clown doll is undamaged:
		record "Clowning Around" as an ending;
		end the story saying "Unfortunately for you, the clown managed to make you fall unconscious and die of a heart attack. Great! Now who am I supposed to make fun of now? Maybe that freak with the glowing red nose will make a good substitute victim... I mean player. Yes... player, that's what I meant."
After attacking the clown doll:
	say "Take that, stupid clown! (The box broke along with the clown doll.)";
	now the clown doll is damaged;
	now the clown doll is in the Basement;
	now the large box is nowhere;
	now the description of the clown doll is "Dead incarnate. In your face, Pennyworth!";
	now the evil clown is in the Floating Basement.
After touching the refrigerator:
	say "It's on and cold."

Before switching off the circuit breaker:
	say "Are you sure this is a good plan?";
	if player consents:
		record "Advance Darkness" as an ending;
		end the story saying "Turning off the breaker has caused the whole place to black out. Now how are we supposed to get anywhere in pitch darkness?";
	otherwise:
		stop the action.

[Cellar - "She thinks my life is easier. I say 'There's no such thing as an easy life.'"]
The Cellar is south of the Basement. The description of the Cellar is "This small-ish room contains a huge amount of supplies. Non-perishable food, wine & alcohol, paper towel & toilet paper, and much more. All the essentials needed for the place. Whoever owns or owned this house must be loaded."

A wine bottle, some paper towels, some cans of food, and some toilet paper are in the Cellar.

The paper towels, and toilet paper are scenery.
The cans of food are fixed in place.
The wine bottle is a closed openable container.
Inside the wine bottle is a black orb.

The description of the wine bottle is "Aged and finely made. '[bold type]Grape Vinery INC: Established AD 33[roman type]'[line break]...What?"
The description of the paper towels is "Incase you ever make a spillage and need to clean it up."
The description of the toilet paper is "I don't need to tell you what this does, ok?"
The description of the black orb is "A small orb of mystery."

After opening the wine bottle:
	say "Upon opening the bottle revealed no wine but a strange little black orb inside."

After taking the black orb for the first time:
	say "A loud clank is made in the Mudroom.";
	now the shovel is in the Mudroom.
	A shovel is a thing.
After rubbing the black orb:
	say "It's not a crystal ball, you know."

Section 3.1 - Domino Effect

[Shovel usage - "I have an irrational ability to say the wrong answer too quickly, which sometimes will turn into an accidental lie."]
The description of the shovel is "A tool used for digging or bashing things in the head with, but is mostly for digging."

After digging the dirt pile with the shovel:
	say "Buried in the mound of dirt was a coin.";
	now the coin is in the Backyard;
	now the dirt pile is nowhere.
	A coin is a thing.

[Coin usage - "I also take too long to answer. Why is my brain so hypocritical?"]
The description of the coin is "A gold coin that has writing inscribed on it saying, 'I need light to grow big and strong.'"

After examining the coin when the dog is calm:
	now the dog is on the large couch;
	now the dog is chill;
	now the description of the dog is "The dog lays comfortably on the couch.";
	now the description of the Living Room is "As you walk back into the living room you find the dog resting in the sunlight on the large red couch. Your dog usually likes doing that because he enjoys the sun on his body. You called it his sunspot.";
	now the description of the Kitchen is "The dog is nowhere to be spotted. Must have moved somewhere else.";
	now the sunlight is in the Dining Room;
	now the description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks. Sunlight from the window is now shining into the room."

After examining the coin when the dog is skiddish:
	now the dog is on the large couch;
	now the dog is upset;
	now the description of the dog is "The dog lays comfortably on the couch.";
	now the description of the Living Room is "As you walk back into the living room you find the dog resting in the sunlight on the large red couch. Your dog usually likes doing that because he enjoys the sun on his body. You called it his sunspot.";
	now the description of the Kitchen is "The dog is nowhere to be spotted. Must have moved somewhere else.";
	now the sunlight is in the Dining Room;
	now the description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks. Sunlight from the window is now shining into the room."

After tasting the coin:
	say "It's not a chocolate coin plus it came out of the ground. Disgusting."

[Optional dog scene - "How did I get this far?"]
Before entering the large couch when the dog is upset:
	if the dog is on the large couch, say "The dog will not let you sit down. He is still upset at you. Maybe this is your chance to apologize."; stop the action.

Before entering the large couch when the dog is chill for the first time:
	if the dog is on the large couch, say "You sit next to the dog and enjoy the sunlight together. He really enjoys your company. Upon further inspection of the dog you find a note that reads:";
	say paragraph break;
	wait for any key;
	say "'[italic type]Don't take the book. The real book is somewhere else, but you can't get to it because the item you need is invisible. Examine the Master's room for a green chest. Inside this chest you will find something that will help you reach the real book. For now, play the game normally until you reach this part of the game. Good luck player![roman type]'";
	say paragraph break;
	wait for any key;
	say "What?";
	wait for any key;
	say "";
	continue the action.

After entering the large couch when the dog is chill for the first time:
	wait for any key;
	say "...this couch is comfy by the way."

[Redemption 2 - "This world is many things."]
After saying sorry to the dog when the dog is skiddish:
	say "The dog forgives you. Now you feel better about yourself as a being.";
	now the dog is calm;
	now the description of the dog is "The dog is [state]. Good dog."

[Redemption 3 - "I don't hate."]
After saying sorry to the dog when the dog is upset:
	say "The dog forgives you. Now you can sit down as long as you behave yourself.";
	now the dog is chill;
	now the description of the dog is "The dog is [state]. Good dog."

[Flowers usage - "They dislike me saying things about them, even in my head."]
The sunlight is scenery.

Before putting the pot of flowers on the large table:
	if the sunlight is in the Dining Room, continue the action;
	otherwise say "Nothing happens."; stop the action.

After putting the pot of flowers on the large table:
	say "The flowers lean towards the sunlight and dance with glee.";
	now the pot of flowers are fixed in place;
	now the description of the pot of flowers is "The flowers are in a joyful bloom.";
	now the clothes pile is in the Basement;
	now the description of the Basement is "Most of the boxes and junk have moved towards the walls, leaving some more room to walk around in. Something must have happened here while you were doing other things."
	The clothes pile is a thing.

Test flowers with "x flowers / smell flowers / take flowers / smell flowers / e / down / e / put flowers on table".

[Clothes usage - "She's always annoyed of asking us to do things. Well, that's life. You can't escape it."]
The description of the clothes pile is "A pile of clothes that needs a good washing."

After inserting the clothes pile into the washer:
	say "You put the clothes in the washer, now close it up."

Instead of inserting the clothes pile into the dryer:
	say "Wrong place."

Instead of closing the washer:
	if the clothes pile is in the washer, continue the action;
	otherwise say "Not yet."; stop the action.

After closing the washer:
	say "You closed the lid and turned it on. Now what? Hey, what's that on the fridge.";
	now the washer is closed;
	now the washer is locked;
	now the description of the refrigerator is "A note on the fridge reads, 'Confucius says: Good things come to those who wait.'"

After waiting:
	say "Don't waste any precious time."

After waiting when the washer is closed:
	say "Time passes. The clothes are done and in that basket here.";
	now the wet clothes pile is in the wicker basket;
	now the wicker basket is in the Basement;
	now the clothes pile is nowhere;
	now the washer is open;
	now the description of the Basement is "Nothing else mysterious has happened while you were waiting for the clothes to finish washing. This basket, on the other hand, has magically appeared with the soaking wet clothes you put in the washer. You didn't even need to open it. Not that you needed to since it cannot be a container and a device at the same time."
	The wet clothes pile is a thing.
	The wicker basket is a open container. It is fixed in place.

After smelling the clothes pile:
	say "You've got issues."
After touching the wet clothes pile:
	say "Soaking wet."

[Wet clothes usage - "At least I try. Is that any better for you?"]
The description of the wet clothes pile is "The clothes pile is wet and needs some hot air."
The description of the wicker basket is "A hand-weaved basket made of thin wooden twigs. Very sturdy and perfect for clothing."

After inserting the wet clothes pile into the dryer:
	say "You put the clothes in the dryer, you know what to do next."

Instead of inserting the wet clothes pile into the washer:
	say "This clothes pile is already soaked."

Instead of closing the dryer:
	if the wet clothes pile is in the dryer, continue the action;
	otherwise say "Not yet."; stop the action.

After closing the dryer:
	say "You closed the lid and turned it on. Good job! You did someone else's laundry. How nice of you to do.";
	wait for any key;
	say "Here, have a cookie for your hard work. You earned it.";
	now the dryer is locked;
	now the dryer is closed;
	now the player is carrying a cookie;
	now the description of the Basement is "You feel proud of yourself for once. I'm sure your mother would feel the same. Speaking of mother, when was the last time you called her?"
	The cookie is edible.

Test clothes with " take clothes / put clothes in washer / close washer /  open washer / x fridge / wait / wait / open washer / take wet clothes /put clothes in dryer /close dryer".

[Reward - "I don't need your pity."]
The description of the cookie is "Snickerdoodle: My favorite."

After eating the cookie:
	say "Eating the cookie has given you the motivation you needed to strive on forward. Now check the fridge.";
	now the giant egg is in the refrigerator;
	now the platform is in the Mudroom;
	now the description of the Mudroom is "A strange platform has appeared unexpectedly in this room. Let's check it out."
	The giant egg is a thing.
	The platform is a supporter.

After tasting the cookie:
	say "Just eat it."

[Egg task - "I sometimes wish rebirth was a thing."]
The description of the giant egg is "An unusually sized egg that has a funky pattern on its shell. You've never seen one this big and beautiful before."
The description of the platform is "On the platform is inscribed 'Put the egg hear and come back later on the other side.' What does it mean by 'other side.'"

After taking the giant egg:
	say "Yeesh... this is heavy.";
	now the refrigerator is closed.

After putting the giant egg on the platform:
	say "Once you set the egg down gently on the platform, light shined upon it. Shortly afterwards, a noise was made in the Bedroom.";
	now the giant egg is fixed in place;
	now the description of the Mudroom is "The egg you placed now stands there as a decoration. The platform told you to come back later, as in some other place that is not here but where you ask yourself. That sentence gives you a chill down your spine for some unexplained reason.";
	now the description of the Bedroom is "There's something hanging on the wall.";
	now the backpack is in the Bedroom.
	The backpack is a wearable container.
	Inside the backpack is a crowbar.

Instead of eating the giant egg:
	say "That might not be very nutritious.";
	wait for any key;
	say "You don't even have anything to cook it with, but why would you want to do that?";
	wait for any key;
	say "You don't know what's even inside the egg.";
	wait for any key;
	say "Plus I'm curious, so no eating it. Capiche?"
	
After tasting the giant egg:
	say "Doesn't have a very distinct taste to it."
After listening to the giant egg:
	say "You hear nothing from inside the egg."
After rubbing the giant egg:
	say  "That will not warm it up enough."
After touching the giant egg:
	say "You can feel life still surging from within the egg."

Section 3.2 - End of the Effect

[The backpack & dog - "I am independent, but also not."]
The description of the backpack is "Used for carrying things and wearing on your back for convenience. It's not just used for school."
The description of the crowbar is "A popular weapon of choice. Now you can feel like a bigger silent protagonist than before."

After wearing the backpack:
	say "The backpack is equipped."

After taking the backpack when the dog is chill:
	say "As you take the backpack a small earthquake happens. The dog runs into the bedroom and blocks the doorway out.";
	now the description of the Bedroom is "Take him with you.";
	now the dog is in the Bedroom;
	now the dog is content;
	now the description of the dog is "He looks agonized as all else. He looks up at you expecting you to take him. Maybe you should.";
	now the description of the Living Room is "It's quiet and empty in here now.";
	now the description of the Backroom is "Most of the boxes feel over from the earthquake. They are at your reach now but nothing in them are of use to you.";
	now the description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. They are all over the floor now.";
	now the description of the photos is "That boy. Why is he so... familiar to you. Maybe you have seen him before... but where?"

After taking the backpack when the dog is upset:
	say "As you take the backpack a small earthquake happens. The dog runs into the bedroom and blocks the doorway out.";
	now the description of the Bedroom is "Take him with you.";
	now the dog is in the Bedroom;
	now the dog is stubborn;
	now the description of the dog is "He looks agonized as all else. He wants you to take him, but not until you say your sorry first.";
	now the description of the Living Room is "It's quiet and empty in here now.";
	now the description of the Backroom is "Most of the boxes feel over from the earthquake. They are at your reach now but nothing in them are of use to you.";
	now the description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. They are all over the floor now.";
	now the description of the photos is "That boy. Why is he so... familiar to you. Maybe you have seen him before... but where?"

Before taking the dog when the dog is content:
	if the dog is in the Bedroom, say "You put him in the backpack. Now you can move on. Get the key in the back room of the basement and head for the Master Bedroom.";
	now the description of the Bedroom is "Having the dog with you makes you feel less isolated.";
	now the description of the Kitchen is "The dog is with you.";
	now the printed name of the dog is "Australian Shepherd - Status: [state]";
	now the description of the dog is "He seems [state].";
	continue the action.

Before taking the dog when the dog is stubborn:
	if the dog is in the Bedroom, say "You've waited long enough. Say it.";
	stop the action.

[Final Redemption - "Maybe I'm not as smart as I my mother thought I was."]
After saying sorry to the dog when the dog is stubborn:
	say "Great! Now he's satisfied.";
	now the dog is content;
	now the description of the dog is "He's waiting for your response."

[Prevent leaving until the dog is taken - "My mistakes only tick them off even more."]
Instead of going east from the Bedroom when the dog is in the Bedroom:
	if the player is carrying the dog, continue the action;
	otherwise say "Looks like you have no choice but to take him with you."

[DOG: Spell that backwards - "If there is a god, why isn't anything getter better? Answer me that."]
Instead of dropping the dog:
	say "You can't."

Instead of inserting the dog into the backpack:
	if the player is carrying the dog, say "You're already carrying him.";
	otherwise say "Type 'take dog' instead."

Instead of taking off the backpack:
	say "No."

[Prevent taking dog early - "Time management, multitasking, priority, common sense, comprehension. They all need improvement."]
Instead of taking the dog:
	if the dog is in the Bedroom, continue the action;
	otherwise say "He doesn't feel like it right now."

[Backroom - "I have to fix things, otherwise the voices won't stop."]
The Backroom is west of the Basement. The description of the Backroom is "More boxes can be found here all stacked up on each other. You won't be able to reach or open most of them because you lack the right tools needed to open them, but they don't seem of importance to you. Most of them are labeled as 'decorations' or 'crafting materials,' none of which are necessary for you."

A trap door and some boxes are in the Backroom.

The trap door is a closed locked container. It is fixed in place.
Inside the trap door is the bedroom key.
The boxes are scenery.

The description of the trap door is "A door used for storing things underneath. It's also used in magic shows and theatre for special effects. The door has been reinforced; you'll need something strong to break it open."
The description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. The boxes you have at home in your basement get cluttered up just like these ones. Maybe you should think about having a garage sale and get rid of some of those old decorations you barely use anymore."
The description of the bedroom key is "The key that unlocks the Master Bedroom. Finally."

Test bedroom with "x backpack / take crowbar / x crowbar / take backpack / wear backpack / x dog / take dog / x dog / say sorry to the dog / x dog / take dog / x dog".

Section 3.3 - The Last Doors

[Trap Door - "Love?"]
After breaking the trap door with the crowbar for the first time:
	say "The door breaks into pieces. Inside the empty hole reveals the bedroom key.";
	now the trap door is damaged;
	now the trap door is open;
	now the trap door is unlocked;
	now the description of the trap door is "It's has broken into many wooden and metal pieces. It is beyond repairs now."

After breaking the trap door with the crowbar:
	say "That's already broken."

Instead of closing the trap door:
	if the trap door is damaged, say "It's impossible to close the door now that its been destroyed.";
	otherwise say "It's already shut tight."

After taking the bedroom key for the first time:
	say "You hear a soft blow of the wind as you take the key.";
	now the description of the Second Floor is "Unlock the Master Bedroom door.";
	now the description of the bedroom door is "You have the key, now unlock it and go inside."

[Bedroom Door - "I hate being cold. At least I don't complain about the heat."]
The bedroom door is a locked door. It is east of the Second Floor and west of the Master Bedroom. The bedroom key unlocks the bedroom door.

The description of the bedroom door is "This door leads to the master's room, but it's locked tightly shut. This person must be hiding something secretive inside. Find the key and then come back here once you've found it."

After unlocking the bedroom door with the bedroom key:
	say "The door makes a [italic type]click[roman type] as you unlock it. You can now enter the Master's Bedroom.";
	now the description of the bedroom door is "The door is unlocked.";
	now the description of the Second Floor is "Go inside. You're almost there."

Section 4.0 - Final Room?

[Master Bedroom - "They hate it when I hide in my sanctuary."]
The description of the Master Bedroom is "This is where the master of the household sleeps in. This is the last room you have yet to check. Could this book here be what you're looking for?"

The pedestal, the master's bed and a recliner chair are in the Master Bedroom.
The pedestal is a supporter. On the pedestal is the book.
The book is a closed openable container.
The printed name of the recliner chair is "recliner".
Understand "recliner" as recliner chair.
Understand "stand" as pedestal.

The description of the book is "A randomly placed book on a small stand. Shall we take it and see?"
The description of the recliner chair is "An ultra comfy chair that has a button that extends the bottom part out as leg rests. Doesn't hurt to give it a try."
The description of the master's bed is "Only the master of the household can sleep here. Of course, he's not here right now. In fact, this house has been quiet, empty, and desolate for some time now. I wonder why. Well, while were thinking about this burning question let's rest."
The description of the pedestal is "A small roman marble column in the shape of a stand. The book sits on top of it like its of great importance."

After entering the master's bed:
	say "Zzzz... soooo soft.";
	wait for any key;
	say "(You're not actually sleeping by the way.)"

After getting off the master's bed:
	say "Ahh, what a nice break that was. Wanna [bold type]save[roman type] your game while your at it? Wouldn't want that angry mole hounding you about not doing it."

After entering the recliner chair:
	say "You sat in the seat and pressed the button on the side. The leg rests pushed out from the front and now you're sitting in style and comfort. Heck yeah!"

After getting off the recliner chair:
	say "Well it was nice while it lasted. You should [bold type]save[roman type] your game just incase."

Section 5.0 - Ending 1

[Taking the book and/or reading it - "My dreams are my only escape out of reality."]
After taking the book for the first time:
	say "Now that you have it, read it.";
	now the description of the book is "...open it up and see."

Before opening the book:
	say "Are you sure?";
	if player consents, continue the action;
	otherwise stop the action.
[Editor's Note: Reading counts as examining so opening the book is the alternative way of ending the game.]

After opening the book:
	say "As you open the book, you skim through the pages. Something seems wrong though.";
	wait for any key;
	say "This book...";
	wait for any key;
	say "...its backwards.";
	wait for any key;
	say "Everything is written backwards.";
	wait for any key;
	say "It even reads backwards, like a manga; from right to left. Could this really have been all that was here?";
	wait for any key;
	say "No missing person but just an old spellbook?";
	wait for any key;
	say "If so, how would you even know what it says or if it's even important?";
	wait for any key;
	say ".....";
	say paragraph break;
	wait for any key;
	say "Let's get out of here.";
	wait for any key;
	clear only the main screen;
	now the player is in the Driveway;
	say "As you leave back to your car, with the dog following you back, you reflect back on everything you have done. In the end, was this all a waste?";
	wait for any key;
	say "Probably not. You did your best but I guess you may never know what really happened here at this old barren house in the middle of nowhere.";
	wait for any key;
	say "Though you can't shake the feeling that something was still missing. Whatever it is, it's probably best left unknown.";
	wait for any key;
	now the left hand status line is "Total turns: [turn count]";
	now the right hand status line is "";
	end the story finally saying "[bold type]End Game. Thanks for playing?[roman type]".
	The Driveway is a room.

Section 6.0 - The Green Chest

[Green Hope Chest - "I was laughed at. They only liked me because my mother was cool."]
A green hope chest is in the Master Bedroom.
The green hope chest is a closed openable container. The green hope chest is scenery. Inside the green hope chest is a scepter.

The description of the green hope chest is "Wait!"
The description of the scepter is "On the scepter is a message. '...mirror...bathroom...' What a cryptic message."
Understand "rod" and "wand" as scepter.

After examining the green hope chest:
	wait for any key;
	say "...what is that?";
	wait for any key;
	say "...a chest?";
	wait for any key;
	say "...was it here the whole time and we haven't noticed it until now?";
	wait for any key;
	say "...?";
	wait for any key;
	say "...shall we take a look inside?";
	now the description of the green hope is "A large green chest that stores blankets and clothing. You did not see it at first because it was invisible to you, but after examining it closely it appeared visible and clear before your very eyes.";
	now the description of the Master Bedroom is "...";
	now the description of the Second Floor is "..."

After opening the green hope chest:
	say "As soon as you open the chest the book magically disappears into thin air. This must be what that note on the dog meant. Inside the chest lies a scepter.";
	now the book is nowhere.

After taking the scepter:
	say "The minute you took the scepter the house shakes violently, causing a black out to happen for a short bit. The dog yelps in fear and when things started to quiet down, you opened your eyes and saw some strange glow emitting outside the room.";
	wait for any key;
	say "";
	say line break;
	wait for any key;
	say "...whatever happens next is beyond me. You should [bold type]save[roman type] while your at it because this adventure ain't over yet.";
	now the dog is scared;
	now the description of the dog is "He's [state] right now.";
	now the description of the Master Bedroom is "The book that was once in here is now gone. Where could it have gone? Somethings telling me that book was not the end of this adventure. Let's get outta here and find out what to do next.";
	now the description of the pedestal is "It's empty now without the book.";
	now the description of the Second Floor is "The glow is coming from the bathroom here.";
	now the description of the Upstairs Bathroom is "The mirror glows radiantly; the scepter is reacting to the mirror.";
	now the description of the Dining Room is "The food on the table has disappeared.";
	now the strange meal is nowhere;
	now the description of the Mudroom is "Something about this egg feels kind of strange.";
	now the description of the Backyard is "There's no birds chirping outside.";
	now the birds are nowhere;
	now the description of the Hallway is "These pictures...";
	now the description of the Bathroom is "The roof of the bathroom has cracked a bit from the earthquake before.";
	now the description of the Guest Bedroom is "The walls are peeling away.";
	now the description of the Basement is "It feels colder now.";
	now the description of the Cellar is "Phew... the room just got warmer all of a sudden.";
	now the description of the Backroom is "The pipes in the wall have busted through and water is dripping out from the cracks.";
	now the description of the mirror is "A doorway?"

Instead of dropping the scepter:
	say "You can't."

Section 6.1 - The Other Side

[Doorway 1 - "What if they don't like it?"]
The mirror is an open door. It is east of the Upstairs Bathroom and west of the Inverted Upper Bathroom.

Instead of going east from the Upstairs Bathroom:
	if the player is carrying the scepter, continue the action;
	otherwise say "That's not possible."; stop the action.

Section 7.0 - The Mirrored Second Floor

[Inverted Upper Bathroom - "Why does she get a job and I don't? She's younger than me and I'm still trying to find one."]
The description of the Inverted Upper Bathroom is "You held the scepter up to the mirror and it sucked you and the dog inside. What is this place? There's a note here. Let's check it out."
The printed name of the Inverted Upper Bathroom is "???".

A red note is in the Inverted Upper Bathroom. The red note is fixed in place.

The description of the red note is "[italic type]Dear Player,[paragraph break]That mirror that you went into has sent you to a new unexplored world where everything is reversed and things don't appear as they did before. Talk about extreme home renovations, am I right? Be prepared because things are going to get stranger and more difficult from this point on. Before you move on I should tell you this. If at any point you feel unsure of what to expect from this new world, examine the dog every once in a while. I've been told they can see ghosts or something but that may be a myth. Either way, he may tell you something that your not entirely aware of. Also if something tragic ever happens to you the dog will leave. You won't notice it at all because you'd be dead at that point and can't check your inventory but he does leave. (I'm only doing this as an illusion so Peta doesn't come after me for dog slaughter. Also I like dogs.) Finally, you can return back to the original house you came in just incase you feel afraid to move on. Just walk back into the mirror. There's nothing else to do there but that option is open to you. And that's all, I think. Good luck and may the force be with you or whatever.[paragraph break]Yours Truly, -----------------[roman type]".

After examining the red note:
	say "Whose this strange person that keeps writing to you? You probably will never know. Anyways, after reading the note your map was updated to the new layout of the house. Check it out whenever your feeling lost.";
	now the small map is nowhere;
	now the red note is nowhere;
	now the player is carrying the large map;
	now the description of the Inverted Upper Bathroom is "Seeing the bathroom in this dimension gives you goosebumps. That strange note you read doesn't help with the anxiety either but at least it gave you some good advice.";
	now the printed name of the Inverted Upper Bathroom is "Inverted Upper Bathroom";
	now the description of the mirror is "The portal that takes you between two dimensions: The Regular House & The Inverted House. (Whatever you do now, don't say [bold type]M-A-R-Y's[roman type] name.)";
	now the inverted toilet is in the Inverted Upper Bathroom;
	now the inverted sink is in the Inverted Upper Bathroom;
	now the description of the Second Floor is "Where to?";
	now the description of the Upstairs Bathroom is "Screams can be faintly heard from the other side.";
	now the description of the dog is "He has nothing to say about this room."

The description of the inverted sink is "Another sink that looks filthy."
The description of the inverted toilet is "Another toilet. It's seat is heavily trashed and beaten up."
The inverted sink is fixed in place.

After switching on the inverted sink:
	say "A strange black liquid flows through the faucet. I'd rather not even try to drink it. Even the dog wishes you don't.";
	now the black liquid is part of the inverted sink.
	The black liquid is a thing.
	The description of the black liquid is "A dark, corrosive substance that just looks disgusting and possibly lethal."
After switching off the inverted sink:
	say "The dark liquid stops flowing.";
	now the black liquid is nowhere.
Instead of drinking the black liquid:
	say "Please don't do that. You don't even know what it is."
Instead of tasting the black liquid:
	say "Just don't."
After touching the black liquid:
	say "You touch this strange goop and immediately pull back your hand after getting stung. Yep, this stuff is dangerous."
Instead of filling the bucket with the black liquid:
	say "Judging by the marks on the sink, this stuff is definitely going to burn through the metal bucket. I'm not sure why the sink is not completely destroyed but it's sure is more durable than this bucket. Let's find something else."
After entering the inverted toilet:
	say "Still don't need to go."

[Prevent moving forward until note is read - "She told me jealousy is a part of life and you have to learn to earn the thing you wish to achieve."]
Before going south from the Inverted Upper Bathroom:
	if the player is carrying the large map, continue the action;
	otherwise say "Let's read the note first."; stop the action.

[Inverted Second Floor Room - "I'm not angry at anyone. I can only be angry at myself."]
The Inverted Second Floor is south of the Inverted Upper Bathroom. The description of the Inverted Second Floor is "Four ways to go. North - Bathroom, East - First Bedroom, West - Second Bedroom, South downward - downstairs. Which way?"

After going north from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "He has nothing to say about this room.";
	continue the action.
After going south from the Inverted Upper Bathroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going east from the Anti-Bedroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going west from the Trespasser's Bedroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going up from the Unliving Room:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.

A garbage can and some writing are in the Inverted Second Floor.
The garbage can is a container. It is fixed in place.
Inside the garbage can is crumpled paper. The crumpled paper is scenery.
The writing is fixed in place.
Understand "paper" as crumpled paper.

The description of the garbage can is "There's a bunch of paper in this garbage can. You could try and do some searching in the garbage can if you like."
The description of the writing is "The writing on the wall says,[paragraph break]'Remember: [bold type]Yes[roman type] means [bold type]No[roman type] & [bold type]No[roman type] means [bold type]Yes[roman type] here.'[paragraph break]What does that mean?"

Instead of inserting something into the garbage can:
	say "That's not a good plan."
After searching the garbage can for the first time:
	say "You rummaged through the crumpled up paper and found a perfectly clean note at the bottom that overshadows the other balls of paper.";
	now Note #1 is in the garbage can.

The description of Note #1 is "[italic type]I've been told by the power company my payment is past due. They say if I don't make the payment by the end of the month they will shut me down. I can't let this happen to myself. I wish I could but I don't have enough money in my account yet. Hopefully I'll be able to earn enough by Tuesday, otherwise I don't know what to do with my life's work.[roman type]"

[Anti-Bedroom - "I'm different. Big whoop."]
The Anti-Bedroom is west of the Inverted Second Floor. The description of the Anti-Bedroom is "The once colorful Master's Bedroom is nothing more than a grey, dull room."

After going west from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "He wants you to lay on the bed, but why?";
	continue the action.

A broken recliner chair, a wrecked bed, a cracked pedestal, and a busted laptop are in the Anti-Bedroom.
The cracked pedestal is a supporter.
The busted laptop is a switched off device. It is fixed in place.
The printed name of the broken recliner chair is "broken recliner".
Understand "stand" as cracked pedestal. Understand "recliner" as broken recliner chair.

The description of the broken recliner chair is "The chair has many rips and holes. The button that brings out the foot rest is stuck inside. That sucks."
The description of the wrecked bed is "The bed is a messed up. The sheets are torn and ripped and the bed is almost to the point of snapping in half."
The description of the cracked pedestal is "The once ornate pedestal is now slightly chipped in various sides. It's also empty and alone. How sad."
The description of the busted laptop is "It's missing many keys from its keyboard. The ones that are still intact are sticky and won't budge."

After entering the broken recliner chair:
	say "The seat is still comfy but the leg rest is stuck inside. No leg rest for you this time."
Instead of switching on the laptop:
	say "The screen is cracked and the battery is dead. There's no way of turning it on."
Before entering the wrecked bed for the first time:
	say "If you do the bed will snap in two.";
	stop the action.
After entering the wrecked bed:
	say "You decided to lay on it anyways. The bed, unfortunately, loses stability of itself and snaps in half. You fall on the floor with a loud thunk. Looks like you won't be laying on that bed ever again.";
	wait for any key;
	say line break;
	say "A note falls out of the bed and onto the floor.";
	now the wrecked bed is damaged;
	now the dog is mortified;
	now the description of the wrecked bed is "The bed is in two pieces; you can't lay on it anymore.";
	now Note #4 is in the Anti-Bedroom.
Instead of entering the wrecked bed when the wrecked bed is damaged:
	say "Not anymore."

The description of Note #4 is "[italic type]Just finished a special mirror that will act as a portal. That people at the university are going to freak when they hear about this. They didn't believe in multiverse's or anything of that sort, but will see about that. I can't wait to show them, granted that it works.[roman type]"

[Trespasser's Bedroom - "I don't like politics as much. They misinterpret them."]
The Trespasser's Bedroom is east of the Inverted Second Floor. The description of the Trespasser's Bedroom is "'You are not welcome here anymore.'"

After going east from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Check the closet.[line break]- Don't open the drawer.";
	continue the action.

A busted closet, a torn-up bed, a dark bureau, a broken desk, a tattered rug, a grandfather clock, and a shattered chair are in the Trespasser's Bedroom.
The busted closet is a closed openable container. Inside the busted closet is a skeleton. The skeleton is fixed in place.
On the skeleton is Note #7.
The dark bureau is a supporter. The hairy drawer is part of the dark bureau. The hairy drawer is a closed openable container.
The tattered rug is fixed in place.
The grandfather clock is fixed in place.
The glass door is part of the grandfather clock.
The dormouse is in the grandfather clock. The dormouse is an animal. The dormouse is female. The dormouse is scenery.
Understand "dresser" as dark bureau. Understand "dresser drawer" as hairy drawer.
Understand "rodent" and "mouse" as dormouse.

The description of the busted closet is "Scratch marks are found all over the closet door."
The description of the skeleton is "A spooky, scary skelly. It brings a shiver down your shine."
The description of the torn-up bed is "Another bed with torn sheets and tears in the pillows."
The description of the hairy drawer is "A really fuzzy drawer of the bureau. Eww..."
The description of the dark bureau is "It's deeply black and has sinister eyes painted on it."
The description of broken desk is "Completely busted and unusable."
The description of the shattered chair is "It's been teared to shreds. You can't sit in it in these conditions."
The description of the tattered rug is "The rug has been mangled up. Pieces of it can be found everywhere on the floor."
The description of the grandfather clock is "A large clock that ticks and tocks the minutes away. Unfortunately its broken and is stuck on the 1st hour. That seems fine for the mouse residing in the clock's glass door."
The description of the dormouse is "A small rodent lives inside the clock. It waves to you on the other side of the glass door. She sits in there in peace and quiet."
The description of Note #7 is "[italic type]Something terrible just happened. The portal is unstable and I can't seem to turn it off.[roman type]"

After opening the busted closet:
	say "'And then a skeleton popped out!'";
	wait for any key;
	say "You aren't afraid of it as much as the clown."
After entering the torn-up bed:
	say "Unlike the bed in the other room this one still supports you despite being in bad conditions."
Instead of putting something on the broken desk:
	say "It can't even support a feather. Poor desk, it won't be able to fulfill its purpose anymore."
Instead of entering the shattered chair:
	say "That's impossible now."
Before opening the hairy drawer:
	say "Open this drawer thing?";
	if player consents:
		stop the action;
	otherwise:
		record "Soft Death" as an ending;
		end the story saying "Upon opening the disgustingly furry drawer, the entire dresser came alive and stuffed you inside the other drawer. Guess that explains why it was so hairy to begin with."
Instead of taking the dormouse:
	say "She seems happy in her little home."
Instead of petting the dormouse:
	say "It's inside the clock and the glass door is tightly shut."
Instead of hugging the dormouse:
	say "As much as she enjoys the affection you give, she can't return the favor."
Instead of attacking the dormouse:
	say "It's not bothering anybody."
After listening to the Trespasser's Bedroom:
	say "[italic type]tick...tock...tick...tock...[roman type]";
	wait for any key;
	say "The clock still makes noise despite not moving its hands."
After touching the hairy drawer:
	say "You feel goosebumps crawling on your skin."

Section 8.0 - The Mirrored First Floor

[Unliving Room - "Do they even care anymore?"]
The Inverted Second Floor is up from the Unliving Room. The description of the Unliving Room is "This place is void of life."

After going down from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.
After going east from the Inverted Dining Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.
After going south from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.

A black chair, 2 shredded couches, the mantle piece, a cracked large window, a split table, a dead television, and a busted door are in the Unliving Room.
The dead television is fixed in place.
The mantle piece is a supporter.
A purple chest is on the mantle piece. The purple chest is a locked openable closed container. It is fixed in place.
The firebrand key unlocks the purple chest.
Note #9 is in the purple chest.
The fireplace is part of the mantle piece. The fireplace is a container. The fireplace is fixed in place.
The firewood is part of the fireplace. The firewood is fixed in place.
The busted door is a door. It is south of the Unliving Room. Through it is A Brick Wall.

The description of the black chair is "Don't be racist to the white chair's cousin, ok? Black chair lives matter."
The description of the shredded couch is "Chewed up and ripped apart. Just like the license plate on your car when that bulldog came over and ripped it off. You managed to get it back at least but barely."
The description of the mantle piece is "It's the only thing in the Gothic room that stands out better than anything else. It has a lovely fireplace with some firewood that burns bright."
The description of the fireplace is "Sit down and get toasty."
The description of the firewood is "There's something in the firewood but the fireplace is lit and so am I. (Don't tell anyone.)"
The description of the cracked large window is "Through the window you see blackish gray landscapes and an red-ish orange sky. Dead tree are everywhere. The entire outside looks barren of life completely. Maybe it's best to stay indoors today, unless you wish to check out the back."
The description of the split table is "This table was split in two. No use putting things onto it."
The description of the dead television is "Dusty and broken."
The description of the busted door is "Despite it being in bad shape it still holds onto its hinges."
The description of the purple chest is "Very ornate and expensive looking."
The description of Note #9 is "This note is written very poorly, but you can still comprehend what is written on it. Here's what it says:[paragraph break][italic type]'I'm stuck like this. I can't go back to who I was before. Unless someone manages to retrieve that book from the 'other side,' then I may have a chance of returning. For now I wait here in my home until that day comes. As for Flahmie, I'm too afraid to see him. I hope he forgives me for what I have done here in my own dimension. Please, someone... anyone who read these notes I made, help us. Take the egg out of the cryogenic fridge and let him hatch. It will make things better for all of us.'[paragraph break]Sincerely, Michael[roman type][paragraph break]...whose Michael?"

Instead of touching the fireplace when the fireplace is smoldering:
	say "Don't touch that it's hot!"
Instead of touching the firewood when the firewood is smoldering:
	say "That's on fire. Don't touch it."
Instead of inserting something into the fireplace:
	say "If you were to put something in the fireplace it will burn up. So the answer to that option is 'No.'"
Instead of entering the shredded couch:
	say "Their not suitable for sitting anymore."
Instead of switching on the dead television:
	say "It's broken like the last one back in the regular dimension. Just give up."
After touching the dead television:
	say "Nope, not this time. I'm on to your little tricks, bud."
Instead of putting something on the split table:
	say "That can't be done; the table is split in half."
After opening the purple chest:
	say "...";
	wait for any key;
	say "Am I detecting a pattern here?"
After listening to the Unliving Room:
	if the firewood is smoldering, say "The firewood in the fireplace crackles.";
	otherwise say "It's quiet in here."
After smelling the firewood:
	say "Smells like burning."

[Busted Front Door - "Being a millennial sucks. Who even invented Generation names in the first place. I hope their proud of themselves."]
After opening the busted door:
	say "The door leads nowhere but a brick wall."; 
	now the description of the busted door is "Good thing you opened it first before just running out without thinking otherwise you would have killed yourself."
Instead of entering the busted door when the busted door is open:
	say "It's bricked up. You can't enter it."
After entering the busted door:
	record "Knock Knock; Whose There?" as an ending;
	end the story saying "You ran face first into a brick wall and died on impact. Ouch!"
Instead of closing the busted door:
	say "It can't be shut anymore. It is locked in position."
Instead of going south from the Unliving Room:
	say "Still cannot go south."

[Inverted Dining Room - "Am I really the enemy?"]
The Inverted Dining Room is west of the Unliving Room. The description of the Inverted Dining Room is "'We are not happy to serve to you.'"

After going west from the Unliving Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- The plate needs a sweet refill.[line break]- He growls at the piano.";
	continue the action.
After going south from the Inverted Kitchen:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- The plate needs a sweet refill.[line break]- He growls at the piano.";
	continue the action.

A worn-out table, 5 withered chairs, a grand piano, a piano bench, a dusty router, and a dead Mac are in the Inverted Dining Room.
The grand piano is a supporter. On the piano is the wilted flowers. The wilted flowers are fixed in place.
The empty plate is on the worn-out table. The empty plate is a supporter. The empty plate is fixed in place.
The dead Mac is a switched off device.
The dusty router is scenery.
Understand "Macintosh" and "desktop" as dead Mac.

The description of the worn-out table is "The table is covered in stains and a lonely plate is left on the side."
The description of the withered chair is "Each chair is slowly withering away, yet they still seem sturdy to hold you."
The description of the grand piano is "You know how to play piano. Maybe you should give it a play when you get the chance."
The description of the piano bench is "The bench is the only thing in this room that is not in bad conditions. I wonder why."
The description of the dead Mac is "An old Macintosh computer. It's connected to the internet router but is barely usable."
The description of the dusty router is "No signal. Figures."
The description of the wilted flowers is "The flowers are all shriveled up."
The description of the empty plate is "Someone or something must have licked this plate clean."

After entering the withered chair:
	say "Yep, Sturdy."
After switching on the dead Mac:
	say "The computer was able to turn on, but only shows a blue screen.";
	wait for any key;
	say "A message is also shown:";
	say line break;
	wait for any key;
	say "01000100 01110101 01100100 01100101 00101100 00100000 01001001 00100111 01110110 01100101 00100000 01100111 01101111 01110100 00100000 01100001 00100000 01000100 01100101 01101100 01101100 00101110";
	say line break;
	wait for any key;
	say "I may be a computer but I don't think I can translate it for you at the moment. Unless you feel like doing it.";
	now the dog is unamused.
After switching off the dead Mac:
	say "The computer goes back to sleep."
After smelling the wilted flowers:
	say "...death.";
	wait for any key;
	say "...that's all you smell."
Before playing the grand piano:
	say "Do you want to play a cheerful song?";
	if player consents:
		stop the action;
	otherwise:
		record "Treble Percussion" as an ending;
		end the story saying "Well, too bad! Instead the piano came alive and ate you up. I guess you can't bring happiness into this world at all."
Instead of touching the grand piano:
	say "You feel an unearthly presence coming from the devious looking percussion instrument."

[Inverted Kitchen - "Am I a roadblock to you?"]
The Inverted Kitchen is north of the Inverted Dining Room. The description of the Inverted Kitchen is "'I wonder what's on the menu today.'"

After going north from the Inverted Dining Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.
After going west from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.
After going south from the Bloodroom:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.

A twin sink, a shattered cupboard, the fake dog, an non-sturdy stool, and a kitchen counter are in the Inverted Kitchen.
The twin sink is fixed in place.
The shattered cupboard is a transparent openable container. It is fixed in place.
The fake dog is an animal.
The kitchen counter is a supporter.
The microwave is on the kitchen counter. The microwave is a container. It is fixed in place.
The turntable is part of the microwave. The turntable is a supporter.
The start button is part of the microwave. It is a device.
The kitchen drawer is part of the kitchen counter. The kitchen drawer is a closed openable container.
The rusty silverware is in the kitchen drawer.
The spider is an animal. The spider is part of the twin sink.
Understand "utensils" and "cutlery" as rusty silverware.
Understand "nuker" as microwave.
Understand "ghost dog" and "werewolf" as fake dog.
Understand "plate" as turntable.
The printed name of the fake dog is "werewolf".

The description of the twin sink is "Two sinks congealed to one another. You see a lone spider perched on the water spout."
The description of the shattered cupboard is "Broken glass can be found on the floor near the cupboard."
The description of the fake dog is "The dog on your back barks angrily at the apparition of its fake predecessor."
The description of the kitchen counter is "The paint job on the counter is fading away and only one drawer is openable."
The description of the kitchen drawer is "The only door that is not glued shut."
The description of the rusty silverware is "Slightly bent and very rusty, but still shiny a bit on certain parts. It's been speculated that werewolves dislike the sighting of silver."
The description of the microwave is "A nuking device for food, not for small rodents. Inside the microwave is a turntable that spins when turned on. The button to start the device is to the right."
The description of the turntable is "A plate that spins with the microwave."
The description of the non-sturdy stool is "The red chair stool is not as sturdy as it used to be."
The description of the spider is "Kill it with fire!"

Instead of taking the fake dog:
	say "I'm pretty sure 'he' would not appreciate it if you did.";
	now the dog is agitated.
Instead of petting the fake dog:
	say "The beastly dog snarls at you. You should probably keep your distance from it.";
	now the dog is agitated.
Before going north from the Inverted Kitchen:
	if the fake dog is not in the Inverted Kitchen, continue the action;
	otherwise say "The ghostly wolf blocks the entrance to the other room."; stop the action.
Instead of opening or closing the shattered cupboard:
	say "Do you want to get a glass cut? I don't think so."
After switching on the start button:
	if the cake is on the turntable:
		record "Tactical Nuke" as an ending;
		end the story saying "You just destroyed an important item. Nice going.";
	otherwise:
		say "The light in the microwave turns on and the plate inside begins to rotate."
After switching on the twin sink:
	say "Nothing but dust puffs out of the faucet.";
	now the dust is part of the twin sink.
	The dust is a thing.
Instead of filling the bucket with the dust:
	say "This sink will not do as it only puffs out dust when turned on. The only places with actual water around here is the sinks in the real world or down in the dungeon."
After smelling the dust:
	say "[italic type]*achoo*[roman type]";
	say line break;
	wait for any key;
	say "Gesundheit.";
	wait for any key;
	say "...";
	wait for any key;
	say "That's German for 'bless you' by the way."
Instead of entering the non-sturdy stool:
	say "It's not even sturdy enough to grasp onto itself, what makes you think it can hold you?"
Before taking the rusty silverware:
	say "Take the silverware?";
	if player consents, stop the action;
	otherwise continue the action.
After using the rusty silverware on the fake dog:
	say "The canine gets spooked by the silverware you wield and disappears. It drops a note on the floor.";
	now the fake dog is nowhere;
	now Note #6 is in the Inverted Kitchen.
Before attacking the fake dog:
	say "I'm pretty sure the last time I checked you can't attack a ghost physically, but do you wanna try anyways?";
	if player consents:
		stop the action;
	otherwise:
		record "Bite > Bark" as an ending;
		end the story saying "Your attack phased through the dog and all of a sudden the ghost of the werewolf retaliated. Now your possessed by the beast and have lost all conscious of your own freewill. You now wander this house endlessly with no real goal to achieve. That's no bueno."
Instead of petting the spider:
	say "Are you freaking nuts?"
Instead of hugging the spider:
	say "I hope you like getting bitten?"
Instead of taking the spider:
	say "Remember that one guy who got bitten by a radioactive spider and became a hero?";
	wait for any key;
	say "Yeah, that won't happen to you."
After attacking the spider:
	record "Charlotte Bit Me" as an ending;
	end the story saying "The spider was quick and nimble and dodged your attack. Before you had a chance for a counterattack, the spider grabbed hold of your weapon and flung you out of the house and locked all the windows and doors. Now your trapped outside and can't get in. The spider refuses to let you back in after that. Looks like this is game over for you because you can't keep moving forward. Maybe next time we should just leave it alone."

The description of Note #6 is "[italic type]I have decided to test it this machine on myself now, because everyone else is too concerned that this may be dangerous for their own well being. I mean, I've tested it on inanimate objects and it works just fine. All I need to do is test it on something living to confirm it's safe and well tested and they refuse to try it out. I already promised them they will be fine. Why can't they just take a chance?[roman type]"

[Long Hallway - "I used to be funny."]
The Long Hallway is east of the Inverted Kitchen and north of the Unliving Room. The description of the Long Hallway is "This new hallway stretches longer than the other hallway. On the floor, you see a red liquid. Is this..."

After going north from the Unliving Room:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going south from the Inverted Lower Bathroom:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going east from the Inverted Kitchen:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going west from the Inverted Bedroom:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going up from the Floating Basement:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.

The small decaying drawer, some inverted photos, and some blood trails are in the Long Hallway.
The inverted photos are fixed in place.
The decaying drawer is a supporter.
The withered school model is on the decaying drawer. It is fixed in place.
The blood trails are scenery.
Understand "red liquid" as blood trails. Understand "pictures" as inverted photos.

The description of the inverted photos is "Various pictures of you and your loved ones hang on the wall. One of them being that vest boy again. How the heck did they get here? Has someone been watching you? This gives you an uneasy vibe."
The description of the withered school model is "A model of your old elementary school. It closed down a long time ago due to a lack of funds and participation. It was tragic for you and your sister to see this happen; so many joyful-ish memories now washed away. It's still around but only as a church. Seeing this thing withering away brings a tear down your eye."
The description of the decaying drawer is "The wood is being chipped away. At the rate of its decomposition it will cease to stand up and support the model on top of it."
The description of the blood trails is "...Blood?"

After examining the blood trails for the first time:
	wait for any key;
	say "...The trails lead down the hallway to each room including the basement.";
	now the description of the Long Hallway is "This new hallway stretches longer than the other hallway. On the floor, you see a trail of blood that stretches down the hallway.";
	now the description of the blood trails is "The trail of blood leads down the hallway to each room including the basement.";
	now the dog is disgusted.
Instead of taking the withered school model:
	say "Sadly you can't take it back home. It's stuck in place and refuses to budge. Farewell, sweet prince.";
	now the dog is sad.
Instead of filling the bucket with the blood trails:
	say "Yes that's a liquid but that's not a very good liquid to fill the bucket with. It would probably make you look like a psycho to be honest."
Instead of tasting the blood trails:
	say "You're not a vampire you sucker."
After listening to the Long Hallway:
	say "You hear echoes coming from various rooms, mostly the bathroom."

[Bloodroom - "What is wrong with me?!"]
The Bloodroom is north of the Inverted Kitchen. The description of the Bloodroom is "A red tainted room. Do I need to go into more details for you?"

After going north from the Inverted Kitchen when the white wyvern is menacing:
	now the dog is petrified;
	now the description of the dog is "He's too focused on the giant lizard to say anything about this room.";
	continue the action.
After going north from the Inverted Kitchen when the white wyvern is content:
	now the dog is content;
	now the description of the dog is "He's not afraid anymore of him.";
	continue the action.
After going north from the Inverted Kitchen when the white wyvern is glad:
	now the dog is content;
	now the description of the dog is "He's proud of what you did before.";
	continue the action.
After going inside from the Cemetery:
	now the dog is content;
	now the description of the dog is "He's got nothing to say about the room.";
	continue the action.

The bloody table, the bloody chair, a dusty platform, 9 stained windows, and the white wyvern are in the Bloodroom.
The dusty platform is an enterable supporter.
The white wyvern is an animal. The white wyvern is male.
Understand "serpent", "lizard", "reptile", "dragon", and "Flahmie" as white wyvern.

The description of the bloody table is "A red table."
The description of the bloody chair is "A red chair."
The description of the dusty platform is "A plaque can found on the side of the platform. It says 'Please refrain from antagonizing Flahmie. He's won't bother you as long as you don't egg him on. If he looks troubled or is in your way, just walk up to him and comfort him. Don't be afraid of him, he's seen things worse than you've seen so far.'"
The description of the stained window is "Through the window you can barely see the outside. All the windows are covered with smudges."
The description of the white wyvern is "YIKES!!!! HOW LONG HAS THAT THING BEEN THERE FOR?!"

Instead of taking the white wyvern:
	say "He's too big and heavy to carry."
Instead of petting the white wyvern when the white wyvern is menacing:
	say "That's a terrible idea you know."
Instead of petting the white wyvern when the white wyvern is lonely:
	say "Go over to him first."
After examining the white wyvern when the white wyvern is menacing for the first time:
	wait for any key;
	say "...sorry, got a little jumpy there. Anyways, the large white reptile stands in the corner, guarding the doorway outside. Instead of attacking you immediately it gazes at you with a stare that makes you tremble.";
	now the description of the white wyvern is "It's like he's piercing into your soul.";
	now the description of the Bloodroom is "There's no way past him unless you can find a way to make him move out of the way of the door. What's that written on the platform over there?"
After examining the dusty platform when the white wyvern is menacing for the first time:
	say "Is it talking about the dragon? And what does he mean walk up to it and pet it? That's crazy... but I guess you have no other choice.";
	now the printed name of the white wyvern is "white wyvern (Flahmie)".
Instead of going outside from the Bloodroom when the white wyvern is menacing:
	say "He won't let you pass."
Instead of going outside from the Bloodroom when the white wyvern is bewildered:
	say "???"
Instead of going outside from the Bloodroom when the white wyvern is lonely:
	say "Can't yet."
Instead of going outside from the Bloodroom when the white wyvern is confused:
	say "..."
After entering the bloody chair:
	say "Huh... neat."
After entering the dusty platform:
	say "You get on the platform. There's eggshell pieces all over it."
Before attacking the white wyvern when the white wyvern is menacing:
	say "Yeah right. You have no chance against a creature like that. Do you really want to try?";
	if player consents:
		stop the action;
	otherwise:
		record "High Five in the Face" as an ending;
		end the story saying "Before you even had a chance to get your weapon out, the giant wyvern slaps you silly across the entire room. It's as if it knew what your next move would be. You hit the wall hard and fall down incapacitated. Told ya you had no chance."
After attacking the white wyvern when the white wyvern is bewildered:
	record "Toasty!" as an ending;
	end the story saying "Annnnnnnd... you've been torched.[line break]I knew that was going to happen. Then again, you did deserve that."
Instead of attacking the white wyvern when the white wyvern is lonely:
	say "No."
Instead of attacking the white wyvern when the white wyvern is confused:
	say "Still no."
Instead of attacking the white wyvern when the white wyvern is content:
	say "Ummm... uh, yeah no."
Instead of attacking the white wyvern when the white wyvern is glad:
	say "Yeah... no."
Instead of attacking the white wyvern when the white wyvern is curious:
	say "The answer is still no."
Instead of attacking the white wyvern when the white wyvern is curious more than five times:
	say "I don't care if [bold type]Yes[roman type] equals [bold type]No[roman type] and [bold type]No[roman type] equals [bold type]Yes[roman type] in this realm.";
	wait for any key;
	say paragraph break;
	say "[bold type]No... is still No![roman type]";
	say line break.
After listening to the Bloodroom:
	say "You hear something awful lurking down below."

Section 8.1 - Confronting the Beast

[The wyvern - "Do you truly believe in hope? I try to."]
After walking up to the white wyvern when the white wyvern is menacing for the first time:
	say "What are you doing?! Have you gone nuts.";
	now the dog is worried.
After walking up to the white wyvern when the white wyvern is menacing for the second time:
	say "No seriously, what?!"
After walking up to the white wyvern when the white wyvern is menacing for the third time:
	say "I'm starting to question your 'good decisions' right now."
After walking up to the white wyvern when the white wyvern is menacing for the fourth time:
	say "Please stop. I don't want this to happen to you.";
	wait for any key;
	say "Or just keep getting closer. I'm kind of curious if this will work."
After walking up to the white wyvern when the white wyvern is menacing for the fifth time:
	say "Agh... I can't watch this any longer than I need to.";
	now the dog is scared.
After walking up to the white wyvern when the white wyvern is menacing for the sixth time:
	say "(Your now at arms reach of Flahmie. What are you going to do now?)[line break]He looks at you with bewilderment.";
	now the white wyvern is bewildered.
After petting the white wyvern when the white wyvern is bewildered:
	say "You reach your hand out to Flahmie. He examines your hand carefully and approaches it slowly.";
	wait for any key;
	say "As soon as you touched him, he sits there contently, looks at the platform for a second and remembers who you are.";
	wait for any key;
	say line break;
	say "Flahmie moves away from the door. He will let you pass now. Also a note appeared on the table. (Wow I can't believe that actually worked. This has been such a weird day.)";
	now the white wyvern is content;
	now the description of the white wyvern is "Flahmie is [state].";
	now the description of the Bloodroom is "Flahmie sits in this room quietly and obedient. He seems to enjoy your company every once in a while.";
	now the description of the giant egg is "...Flahmie.";
	now the printed name of the white wyvern is "white wyvern (Flahmie)";
	now Note #3 is on the bloody table;
	now the dog is bewildered.
After petting the white wyvern when the white wyvern is content:
	say "(Man, wait until the boys back at home hear about this.)"
After petting the white wyvern when the white wyvern is glad:
	say "This is best thing that's ever happened to you in your life. You will be the envy of your friends when you tell them this."
After petting the white wyvern when the white wyvern is curious:
	say "If only he was smaller then you could take him with you. The dog seems rather used to his presence now.";
	now the dog is content.
After walking up to the white wyvern when the white wyvern is lonely:
	say "You approach Flahmie slowly.";
	now the white wyvern is confused.
After petting the white wyvern when the white wyvern is confused:
	say "The gentle stroke of your hand on his forehead made him feel better of himself. He moves out of the way of the door to the cemetary and asks you to be prepared for what's waiting on the other end. There was a reason he was guarding the doorway outside. Something deadly hides underneath these headstones.";
	now the white wyvern is glad;
	now the description of the white wyvern is "Flahmie is [state] to see you.";
	now the description of the Bloodroom is "Flahmie sits in this room quietly and obedient. He really enjoys your company here every once in a while.";
	now the description of the giant egg is "...Flahmie.";
	now the printed name of the white wyvern is "white wyvern (Flahmie)";
	now Note #3 is on the bloody table;
	now the dog is content.
After hugging the white wyvern when the white wyvern is confused:
	say "(This will work too I guess.) He realy enjoyed the comfort you gave him and moves out of the way of the door to the cemetary and asks you to be prepared for what's waiting on the other end. There was a reason he was guarding the doorway outside. Something deadly hides underneath these headstones.";
	now the white wyvern is glad;
	now the description of the white wyvern is "Flahmie is [state] to see you.";
	now the description of the Bloodroom is "Flahmie sits in this room quietly and obedient. He really enjoys your company here every once in a while.";
	now the description of the giant egg is "...Flahmie.";
	now the printed name of the white wyvern is "white wyvern (Flahmie)";
	now Note #3 is on the bloody table;
	now the dog is content.

The description of Note #3 is "[italic type]This egg I found is rather unusual. I feel like I should conserve it somewhere just incase. I don't have time to watch over it as of now plus it doesn't seem ready to be hatched yet. I wonder what it will be when it does? A dragon maybe?[line break]...Nah that seems too good to be true.[roman type]"

[Cemetery - "I just want to be a part of the crowd."]
The Cemetery is outside of the Bloodroom. The description of the Cemetery is "The dry wind howls in an eerie tone."

After going outside from the Bloodroom:
	now the dog is content;
	now the description of the dog is "All he asks is that you don't lose your knife when pushing the loose tombstone.";
	continue the action.

The tombstone, some dead grass, some dead trees, a metal fence, some gray clouds, a corrupted shed, and the orange sky are in the Cemetery.
The dead grass, dead trees, gray clouds, and orange sky are scenery.
The fence door is part of the metal fence. The fence door is a closed openable container.
A rock is a thing.
The corrupted shed is fixed in place.
Understand "headstone" as tombstone.

The description of the tombstone is "'You're next!' says one of the many tombstones. The one to your left looks loose and can easily be moved."
The description of the dead grass is "Dark gray and void of life."
The description of the dead trees are "They stand up tall with a ghastly shadow looming on you."
The description of the gray clouds are "Not a single silver lining can be found on each cloud."
The description of the orange sky is "It's deep, dark, and orange."
The description of the metal fence is "The entire borderline of the house is surrounded by the fence."
The description of the fence door is "Opening the fence would let you leave, but you can't because its locked up."
The description of the rock is "Small, hard, and gray. Good throwable material.[line break](P.S. - Don't throw it at any windows.)"
The description of the corrupted shed is "There's nothing you can do with this shed. The door to open it is cursed. Writing can be found on the side of the dark purple shed.[paragraph break]l_v_ng[line break]c_ll_r[line break]m_st_r[line break]tr_sp_ss_rs[line break]bl__d[line break]b_ck[paragraph break]The rest of it has been scratched off."

Instead of opening the fence door:
	say "'There is no escape.'"
Instead of taking the tombstone:
	say "That's too heavy to take."
After listening to the Cemetery:
	say "Crows can be heard cawing in the distance."

Section 8.2 - Battle Time

[The Zombie Battle - "He thinks I'm weak, I just know it."]
Before pushing the tombstone:
	say "Push the stone?";
	if player consents, stop the action;
	otherwise continue the action.

After pushing the tombstone for the first time:
	say "You pushed the heavy tombstone out of the way. Suddenly, a zombie pops out of the ground. Whoa![line break]You immediately back away and head towards the door back inside but as you approached the door, a bunch of prickly vines grew around it blocking your escape. Looks like you have no choice but to defeat the zombie.";
	now Zombie 1 is in the Cemetery;
	now some vines are in the Cemetery;
	now the description of the Cemetery is "I hope you didn't throw that knife away.";
	now the description of the tombstone is "'See? Too ya you were next?'";
	now the dog is disgusted.
	The description of Zombie 1 is "Undead and out for flesh."
	The description of the vines are "Sharp and pointy. No way of cutting them down."
	The vines are scenery.

Instead of going inside from the Cemetery when the vines are in the Cemetery:
	say "Trapped."

After attacking Zombie 1:
	say "You attacked the zombie and it fainted.

	Two more appear.[line break](Examine each zombie to know which one to attack next. Choosing the wrong one may end your life.)";
	now Zombie 1 is nowhere;
	now Zombie 2 is in the Cemetery;
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "Choose wisely."
	The description of Zombie 2 is "The left zombie is about to attack."
	The description of Zombie 3 is "The right zombie is waiting."

After attacking Zombie 2 when Zombie 2 is attack for the first time:
	say "The zombie fainted.

	Another zombie appeared.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "What! Another one?"
	The description of Zombie 4 is "The middle zombie is waiting."

After attacking Zombie 3 when Zombie 3 is attack for the first time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 2 is in the Cemetery;
	now the description of the Cemetery is "Oh no."

After attacking Zombie 4 when Zombie 4 is attack for the first time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 2 is attack;
	now the description of Zombie 2 is "The left zombie is about to attack.";
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "This is gonna go on for a while huh?"

After attacking Zombie 2 when Zombie 2 is attack for the second time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "Yep."

After attacking Zombie 4 when Zombie 4 is attack for the second time:
	say "The zombie fainted.

	Another one appeared. (Jeez... their relentless.)";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 2 is in the Cemetery;
	now the description of the Cemetery is "Keep at it."

After attacking Zombie 3 when Zombie 3 is attack for the second time:
	say "The zombie fainted.

	And another one.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "Don't lose focus."

After attacking Zombie 4 when Zombie 4 is attack for the third time:
	say "The zombie fainted.

	Another zombie. (I knew playing Resident Evil was a bad idea.)";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "Your almost there."

After attacking Zombie 3 when Zombie 3 is attack for the third time:
	say "The zombie fainted.

	One left... literally left.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 2 is attack;
	now the description of Zombie 2 is "The left zombie is about to attack.";
	now the description of the Cemetery is "Hit 'em hard."

After attacking Zombie 2 when Zombie 2 is attack for the third time:
	say "The zombie fainted.

	I guess that's all of the...";
	wait for any key;
	say "oh wait, nevermind.";
	wait for any key;
	say "Another zombie just appear and this one looks bigger than the others.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 5 is in the Cemetery;
	now the description of the Cemetery is "Show no mercy."
	The description of Zombie 5 is "The zombie is going for an attack."

After dodging Zombie 5 when Zombie 5 is attack:
	say "You dodged the upcoming attack. It's vulnerable for attack.";
	now Zombie 5 is vulnerable;
	now the description of Zombie 5 is "The zombie is vulnerable.";
	now the description of the Cemetery is "Good call."

After attacking Zombie 5 when Zombie 5 is vulnerable for the first time:
	say "The zombie got damaged. It readies itself.";
	now Zombie 5 is dodge;
	now description of Zombie 5 is "The zombie is preparing for an attack.";
	now the description of the Cemetery is "Not too shabby."

After attacking Zombie 5 when Zombie 5 is dodge:
	say "The attack missed.";
	now Zombie 5 is attack;
	now the description of Zombie 5 is "The zombie is going for an attack.";
	now the description of the Cemetery is "Keep going."

After waiting when Zombie 5 is dodge:
	say "You waited for a clear opening.";
	now Zombie 5 is attack;
	now the description of Zombie 5 is "The zombie is going for an attack.";
	now the description of the Cemetery is "Smart move."

After attacking Zombie 5 when Zombie 5 is vulnerable for the second time:
	say "The zombie gets damaged and dissipates into nothing.

	The zombies stop spawning. Thank goodness. As the large zombie disappears it leaves behind a note and a rock.";
	now Zombie 5 is wait;
	now the description of Zombie 5 is "Dead.";
	now Zombie 5 is nowhere;
	now the vines are nowhere;
	now Note #8 is in the Cemetery;
	now a rock is in the Cemetery;
	now the description of the Cemetery is "The winds are still howling in an eerie tone.";
	now the description of the Backyard is "The birds chirp again.";
	now the birds are in the Backyard;
	now the description of the tombstone is "'I knew I should have called a vampire instead.'";
	now the dog is glad.

The description of Note #8 is "[italic type]Now the machine won't cooperate. I don't understand. Why are these contraptions going all haywire? They were just working fine before.[roman type]"

[Wrong Decision - "I sometimes have multiple existential crisis's."]
After attacking a wait zombie:
	record "False Move" as an ending;
	end the story saying "Wrong."

After attacking Zombie 5 when Zombie 5 is attack:
	record "So Close" as an ending;
	end the story saying "Dead."

[Inverted Lower Bathroom - "Being a child kind of sucked, but it also was easier."]
The Inverted Lower Bathroom is north of the Long Hallway. The description of the Inverted Lower Bathroom is "Another unwashed bathroom. Good thing you already took a shower before you left."

After going north from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Check back with the cabinet when you have 8 notes.[line break]- Don't go into the bathtub.";
	continue the action.

A shattered medicine cabinet,a bent toilet, a broken bathtub, and a warped sink are in the Inverted Lower Bathroom.
The warped sink is fixed in place.
The shattered medicine cabinet is a container. It is fixed in place.
Inside the shattered medicine cabinet is Note #5.
The broken bathtub is an enterable supporter.
Understand "tub" as broken bathtub.

The description of the shattered medicine cabinet is "The mirror and door have fallen off the cabinet. It hangs on the wall empty and barren."
The description of the broken bathtub is "Cracks can be found everywhere on the exterior of the tub. The curtains that company the tub are all wrinkled up."
The description of the bent toilet is "The toilet is all disfigured and out of proportion with itself."
The description of the warped sink is "It's handles and bowl bend in irregular shapes."
The description of Note #5 is "[italic type]Well now that I'm done with that invention I'll just continue on my other project. This project is expected change the appearance or any living creature into something else, including people. I can just imagine what wonders people will think of this. Running as fast as a cheetah, soaring the sky like an eagle, or visiting the vast depths of the ocean as a whale. I swear, this will change the world indefinitely. Now who to test it on is the question?[roman type]"

After entering the bent toilet:
	say "Still don't need to go."
After switching on the warped sink:
	say "Red mist flows out of the sink and up into the air.";
	now the red mist is part of the warped sink.
	The red mist is a thing.
	The description of the red mist is "Upon examining this hazy red mist that defies gravity, you can hear faint whispering coming from the sink."
After switching off the warped sink:
	say "The mist stops flowing and the sounds fade away.";
	now the red mist is nowhere.
Instead of filling the bucket with the red mist:
	say "Gases are not solid enough to be liquid unless it was to rain. I would call Don Decker to help us out, but he's got his own problems to take care of."
Before entering the broken bathtub:
	say "Lay in the tub?";
	if player consents:
		stop the action;
	otherwise:
		record "Rub a Dub, Scrub" as an ending;
		end the story saying "As you enter the tub, the shower curtains close up and a thick glass wall blocks your way out entirely. Water spurts out of the shower head at a furious pace, causing the tub to fill up really quickly. The water level eventually reaches to the top of the ceiling and you desperately try to break you way out, but to no prevail do you succeed in escaping. The dog on the other side of the glass whimpers to you and tries to help you out but fails as well. Eventually, you gasp you last breath and go out quietly. What a terrible way to go."
After listening to the warped sink:
	if the warped sink is switched on, say "[italic type]R̴u̵f̵u̷ ̷k̴u̷n̷e̵ ̶v̸o̶s̷e̷ ̷v̶a̴n̷o̵u̵y̵a̷ ̵p̶a̸n̸o̶.̵ ̴K̶u̴p̵a̷r̷a̷d̸z̵w̶a̴ ̸k̵u̴r̸i̸ ̷p̸a̸m̷u̸s̶o̴r̶o̵ ̷p̸e̵d̶u̶.̷ ̸D̷z̴o̸s̸a̴ ̸r̷i̴m̵a̵ ̵r̸i̵n̶o̸m̶i̵r̸i̸r̷i̸r̸a̵ ̴r̸i̴s̴a̸t̴i̵ ̷r̵a̷k̷u̸p̵a̴r̷a̵d̸z̵a̸ ̸i̶w̶e̴.̶ ̶K̴a̴n̸a̴ ̴z̷v̸i̸s̷i̵n̸a̵ ̵k̴u̸d̴a̵r̴o̶,̴ ̴z̴u̷v̸a̵ ̵r̵e̶k̴u̵p̵a̵r̸a̴d̵z̵w̵a̵ ̵r̸i̸c̴h̷a̵s̷i̷m̵u̸d̶z̶a̸ ̶k̸u̶t̸s̶a̸m̴w̷a̴ ̴k̶u̵n̸o̵p̴i̵s̸a̵.[roman type]";
	otherwise say "You hear nothing from the sink."

[Inverted Bedroom - "Writing is the only way I can clear my thoughts out fully."]
The Inverted Bedroom is east of the Long Hallway. The description of the Inverted Bedroom is "'Rest a while. Rest forever!'"

After going east from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Get the coat.[line break]- Don't go inside the armoire or turn on the TV.";
	continue the action.

A king-size bed, a chipped wardrobe, a busted clock, and a small broken television are in the Inverted Bedroom.
The small broken television is fixed in place.
The chipped wardrobe is an enterable container. It is fixed in place.
The thermal coat is in the chipped wardrobe. The thermal coat is wearable.
The busted clock is fixed in place.
The inverted closet is an enterable closed openable container. It is fixed in place.
Understand "armoire" as chipped wardrobe. Understand "winter coat" as thermal coat.

The description of the king-size bed is "A bed fit for a king. It's the only bed that has been left undamaged but has grown dusty and uncomfortable to lay on."
The description of the chipped wardrobe is "The doors on the wardrobe are missing and the outside of the closet is in bad shape."
The description of the busted clock is "The second and minute hand is stuck ticking in the same position while the hour hand got bent."
The description of the inverted closet is "Another ruined closet."
The description of the small broken television is "Smoke is emitting out of the back of the television. The TV is trying to turn itself on but shuts off immediately when trying, leaving behind a mess of static each time."
The description of the thermal coat is "Big, blue, and fluffy on the inside. Looks tough and cozy."

After entering the king-size bed:
	say "[italic type]*cough cough*[roman type] ...it's... [italic type]*cough*[roman type] ...so hard... [italic type]*aaach*[roman type] ...to breath... [italic type]*cough hack*[roman type]".
Before entering the chipped wardrobe:
	say "Enter the wardrobe?";
	if player consents:
		stop the action;
	otherwise:
		record "For Narnia!" as an ending;
		end the story saying "As you approach the wardrobe a lion pops out from behind the coats hung up inside the wardrobe and drags you in. You never came back out of the armoire again."
Before switching on the small broken television:
	say "Wanna try and turn it on yourself?";
	if player consents:
		stop the action;
	otherwise:
		record "Boobtube Combustion" as an ending;
		end the story saying "The TV flashes a million images simultaneously and then combusted in your face. The explosion left you impaled and on the ground. I don't think you survived that, but at least the dog did."
After entering the inverted closet for the first time:
	say "No... No... No... We are not playing this game again. In fact, I'm not going to even ask you anymore, I'm just going to wait until you decided to cooperate with me and play this game the way it was intended to be played. So there.";
	now the closet is locked;
	now the closet is closed;
	now the description of the closet is "[bold type]Sucker![roman type]".
Instead of opening the closet when the closet is locked:
	say "Nope.avi";
	say line break.
After entering the inverted closet:
	say "..."
Before taking the thermal coat:
	say "Take the thermal coat?";
	if player consents, stop the action;
	otherwise continue the action.
After wearing the thermal coat:
	say "A horrible chill runs down your spine as you put on the coat."

[Prevent wearing two layers at once - "I'm still here."]
Instead of wearing the thermal coat:
	if the player is wearing the brown jacket, say "You'll need to take off your jacket first.";
	otherwise continue the action.

Instead of wearing the brown jacket:
	if the player is wearing the thermal coat, say "You'll need to take off your coat first.";
	otherwise continue the action.

Section 8.3 - The Underground

[Prevent going downstairs again without another equipped item - "Disappointment is common."]
Instead of going down from the Long Hallway:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "A cold breeze prevents you from entering the basement."

Instead of going north from the Burning Cellar:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "It's too cold in there. You'll freeze up without proper protection from the extreme weather."

Instead of going west from the Back Dungeon:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "It's too cold in there. You'll freeze up without proper protection from the extreme weather."

Section 9.0 - Hell's Basement

[Floating Basement - "Ignorance is still bliss."]
The Floating Basement is down from the Long Hallway. The description of the Floating Basement is "...I have no words for this place other than how chilly it is in here."

After going down from the Long Hallway:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.
After going north from the Burning Cellar:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.
After going west from the Back Dungeon:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.

A freezer box, a corrupted washer, a corrupted dryer, a torn-up wicker basket, ice, some icicles, a sealed circuit breaker, and some dangling chains are in the Floating Basement.
The dangling chains, ice, and icicles are scenery.
The freezer box is an open container. The freezer box is fixed in place. The freezer box can be cold. The freezer box is cold.
The corrupted washer and corrupted dryer are a switched on device.
The corrupted washer and corrupted dryer are fixed in place.
The evil clown is a man.
The torn-up wicker basket is a container. It is fixed in place.
Inside the torn-up wicker basket is a gas mask.
The gas mask is wearable.
The sealed circuit breaker is a device. The wires are part of the sealed circuit breaker.

The description of the freezer box is "Unlike a refrigerator, a freezer box will keep food cold and frozen. The freezer door is wide open and is causing the ceiling to solidify with icicles and the floor to become slippery. Watch your step."
The description of the corrupted washer is "This washer has been tampered with and is causing a flurry of snow to pump out constantly."
The description of the corrupted dryer is "The dryer is malfunctioning and is making vapor puff out uncontrollably."
The description of the evil clown is "That clown is out for blood. If I were you I would stay as far away from it as possible."
The description of the torn-up wicker basket is "The basket has been stretched into pieces. It is perched on one of the many dangling chains in the room."
The description of the dangling chains are "Various chains dangle everywhere. Some on the ceiling and many on the floor hovering in midair."
The description of the ice is "This room is nothing but ice."
The description of the icicles are "They hang there on the wall, waiting for someone to walk by so they can fall off the ceiling and impale their next victim."
The description of the gas mask is "A mask used for breathing in noxious places."
The description of the sealed circuit breaker is "The circuit breaker has been sealed shut with no way of operating it. Nothing but wires protrude from each side of the box."
The description of the wires are "Various wires tangle and twist in many directions. They can be found on the walls, in the walls, up and down each room of the house, and even outside. They are incredibly thick and cannot be cut. But why would you want to do that? That can be very dangerous."

Instead of switching on or switching off the sealed circuit breaker:
	say "That's a bit far-fetched, don't you think?"
Instead of switching off the corrupted washer:
	say "The washer refuses to be shut off."
Instead of switching off the corrupted dryer:
	say "The dryer's off switch is stuck. No way of calming this thing down."
Instead of taking the evil clown:
	say "Don't."
Instead of walking up to the evil clown:
	say "I'd rather you not."
After attacking the evil clown:
	record "We All Float" as an ending;
	end the story saying "You were no match for the clown. Perhaps there's another way of dealing with him."
Instead of taking off the thermal coat in the Floating Basement:
	say "Do you want to be turned into a Popsicle?"
Instead of closing the freezer box:
	say "The door is frozen in place."
Instead of taking the gas mask:
	if the evil clown is in the Floating Basement, say "You can't get to the mask with that dastardly clown blocking the way.";
	otherwise continue the action.
Before taking the gas mask:
	say "Get the mask?";
	if player consents, stop the action;
	otherwise continue the action.
After wearing the gas mask:
	say "Great! Now you can enter the room to the south."
After touching the ice:
	say "Cold."
After touching the freezer box:
	say "F-F-Freezing."
After touching the wires:
	say "[italic type]*Bzzzt*[roman type] Ouch!"
After listening to the Floating Basement:
	say "...................................................."

[Rock throw - "At least I was trying to be good in school, and I did for the most part."]
Before throwing the rock at the icicles:
	if the evil clown is in the Floating Basement, continue the action;
	otherwise say "There's no need to do that."; stop the action.

After throwing the rock at the icicles:
	say "One of the large icicles falls off the ceiling and jabs the clown, who bursts into a pile of confetti afterwards. I guess that's one way of dealing with a psychotic clown.";
	now the evil clown is nowhere;
	now the rock is nowhere;
	now some confetti is in the Floating Basement.
	The confetti is fixed in place.
	The description of the confetti is "Colorful."

[Prevent going into the Fire Cellar without mask - "Even if I was to leave, I'd still be here."]
Instead of going south from the Floating Basement:
	if the player is wearing the gas mask, continue the action;
	otherwise say "A strong feeling inside you is telling you not to go in that room without a protective mask."

[Burning Cellar - "Depression is normal, right?"]
The Burning Cellar is south of the Floating Basement. The description of the Burning Cellar is "WHOA!!! This place is on fire! Literally!"

After going south from the Floating Basement:
	now the dog is worried;
	now the description of the dog is "Search through the papers and quickly.";
	continue the action.

Some burnt paper and fire are in the Burning Cellar.
The fire is scenery.
The burnt paper is fixed in place.

The description of the fire is "Fire's roar through the cracks in the walls, leaving behind ashes and smoke everywhere."
The description of the burnt paper is "All the paper goods are tarnished and covered in black soot. You can, however, search through them for anything since they are away from the fire."
The description of the white orb is "A small orb of illusion."

Instead of taking off the gas mask in the Burning Cellar:
	say "Don't do it. You'll suffocate if you do."
After searching through the burnt paper for the first time:
	say "You scavenged through the rubble of charred paper and found a white orb.";
	now the white orb is in the Burning Cellar;
	now the description of the burnt paper is "The papers turned into black dust after you searched through them.";
	now the printed name of the burnt paper is "black dust".
After rubbing the white orb:
	say "Still not magical."
Instead of touching the fire:
	say "Oh my giddy aunt, no."
After listening to the Burning Cellar:
	say "Fire's rage and burn."

[White orb - "It's not a waste. None of it was."]
After taking the white orb for the first time:
	say "You hear something upstairs.";
	now the start button is switched off;
	now the cake is on the turntable;
	now the bucket is on the bloody table.
	The cake is edible.
	The bucket is an empty container.
	The description of the cake is "It's a lie, don't eat it!"
	The description of the bucket is "An empty, dry bucket."

[The cake act - "I'm not a quitter, especially when it comes to college."]
Before taking the cake:
	say "Take the lie?";
	if player consents, stop the action;
	otherwise continue the action.

Instead of eating the cake:
	say "After taking one lick from the cake you shoved it away from your mouth immediately. It tastes terrible."

After putting the cake on the empty plate:
	say "You place the cake on the plate. This cake was meant to be placed here; it just feels right.

	Upon further inspection, a note appeared next to the cake.";
	now Note #2 is on the worn-out table;
	now the cake is fixed in place;
	now the description of the cake is "Still a lie, don't eat it.";
	now the description of the empty plate is "Whole again.";
	now the description of the Dining Room is "A ghostly figure appears on the table.";
	now the ghost is in the Dining Room;
	now the printed name of the empty plate is "plate".
	The ghost is a thing. It is fixed in place.
	The description of the ghost is "It seems to be minding its own business."

The description of Note #2 is "[italic type]Good news, just paid off the electric bill. Bad news, the news has reported that people have been losing power unexpectedly and I just so happen to be one of them. At least I was about to leave my inventions unplugged and in conservative mode before this happen. This stuff is delicate and a working progress so the last thing I want happening is something bad happening to me, my loved ones or anything else I cherish.[roman type]"

[The bucket act - "I will never lose hope. The candle's ember still burns inside me."]
Before taking the bucket:
	say "Grab the bucket?";
	if player consents, stop the action;
	otherwise continue the action.

After taking the bucket:
	say "Feels sturdy. This may come in some good use.";
	now the white wyvern is curious;
	now the description of the white wyvern is "Flahmie is [state] as to what you will be doing next."

After filling the bucket with the water:
	say "You filled the bucket with water.";
	now the bucket is waterfilled;
	now the description of the bucket is "A wet, water-filled bucket."

Instead of filling the bucket with a thing when the bucket is waterfilled:
	say "It's already full. It can't hold anymore."

After filling the bucket with a thing:
	say "That is not a liquid."

Instead of filling the backpack with the water:
	say "That's not a good filler for liquids. Also the dog is residing in the backpack, so he may not appreciate being soaking wet either."

After pouring the bucket on the firewood when the bucket is waterfilled for the first time:
	say "You poured the water on the fire and it goes out.";
	now the bucket is empty;
	now the description of the bucket is "Empty again.";
	now the fireplace is cool;
	now the firewood is soggy;
	now the description of the fireplace is "Not so toasty anymore.";
	now the description of the firewood is "The wood is all moist.";
	now the description of the Living Room is "It smells like smoke in here.";
	now the firebrand key is in the fireplace.
	The description of the firebrand key is "'That's a spicy meatball.' It unlocks the chest on the mantle piece."

After pouring the bucket on the firewood when the bucket is waterfilled:
	say "The fire is already out, but whatever.";
	now the bucket is empty;
	now the description of the bucket is "Empty again."

After pouring the bucket on a thing when the bucket is empty:
	say "It doesn't have any liquid in it."

After pouring the bucket on a thing when the bucket is waterfilled:
	say "How about you pour the water on something that's hot and not ruin the object your're trying to soak."

[Back Dungeon - "Please don't take any of this the wrong way."]
The Back Dungeon is east of the Floating Basement. The description of the Back Dungeon is "It's damp in here."

After going east from the Floating Basement:
	now the dog is content;
	now the description of the dog is "He's silent. Looks like you'll have to figure it out from here.";
	continue the action.

A wooden signpost, 6 rickety cages, some skulls, some bone piles, some puddles, some waterfalls, some torches, some stalactites, some stalagmites, and a shrine are in the Back Dungeon.
The wooden signpost is fixed in place.
The rickety cage is fixed in place.
The skulls, bone piles, puddles, torches, stalactites, and stalagmites are scenery.
The waterfalls are fixed in place.
The shrine is fixed in place.
The altar is part of the shrine. The altar is a supporter.
The plaque is part of the shrine.
The ivy is part of the shrine.
The doppleganger is a man.
The doppleganger is carrying the cursed sword.
Understand "tiny pools" as puddles.
Understand "dark twin", "faker", "impersonator", "copycat", and "demon" as doppleganger.

The description of the wooden signpost is "'Welcome to your new home soon.'"
The description of the rickety cage is "This dank, dark cave consists of a few metal cages that sway back and forth from the ceiling. Most of them are being occupied by nothing but skulls and bones."
The description of the puddles are "Water puddles can be found everywhere on the floor. The stalactites are dripping off water from the leaky lime-diseased ceiling, which is causing these puddles and stalagmites to form."
The description of the stalagmites is "Various floor pillars made by the saltwater leaking from the ceiling. Their cousins, the stalactites, like to hang around on the ceiling."
The description of the stalactites is "Various ceiling spears made by the saltwater leaking from the ceiling. Their cousins, the stalagmites, like to chill on the cave floor."
The description of the skulls are "Unidentified skulls are found everywhere in the room including the walls."
The description of the bone piles are "Several huge piles of pale bones are located in certain parts of the room. They are also accompanied by pale skull heads as well."
The description of the waterfalls is "Water seams through the cracks and a few small drains create small waterfalls on the top edges of the walls. The waterfalls have made puddles and tiny pools from the divets in the ground."
The description of the shrine is "A small shrine stands at the far end of the room with a small staircase leading up to the altar. It is decorated with ivy all over and has a few torches perched in a neat row to signify it as something important."
The description of the altar is "There is nothing on the altar. A plaque can be found in front of it."
The description of the plaque is "'[italic type]hturt eht wonk ot seton enin eht dinf[roman type]'[paragraph break] This text is kinda hard to make out."
The description of the ivy is "Various vines that grow on the side of structures and walls. Some tend to be a nuisance for people with gardens while other times they make even the most dull kinds of man-made creations a little more... mystical in a sense. That is, if this shrine was actually man-made."
The description of the cursed sword is "A sword that illuminates a deadly glow."
The description of the doppleganger is "It's your look-alike. He's just standing there... menacingly."

Instead of entering the rickety cage:
	say "These cages are for locking up bad people with bad intentions and you my friend are no bad person...";
	wait for any key;
	say "[italic type]hopefully[roman type]."
Instead of taking the doppleganger:
	say "Bad idea."
After listening to the Back Dungeon:
	say "Water flows and drips down from the ceiling and walls."

Section 10.0 - The True Final Room

[The 9 Notes - "Sometimes you just need to vent out your frustration."]
Check taking inventory:
	if the player is carrying nine mysterious papers:
		say "[italic type]You got all the mysterious notes![roman type]".

Instead of taking Note #5:
	if the player is carrying eight mysterious papers, continue the action;
	otherwise say "This note won't budge."

Instead of examining Note #5:
	if the player is carrying eight mysterious papers, continue the action;
	otherwise say "The back side of the note is only shown. A large number 8 is drawn on it."


After taking Note #5:
	say "That was the last note in the entire house.";
	wait for any key;
	say "Great job!";
	wait for any key;
	now the printed name of the Inverted Lower Bathroom is "Inverted Bathroom (Dark)";
	now the printed name of the Long Hallway is "Hallway (Dark)";
	now the printed name of the Inverted Bedroom is "Bedroom (Dark)";
	now the printed name of the Inverted Kitchen is "Kitchen (Dark)";
	now the printed name of the Bloodroom is "Red Room (Dark)";
	now the printed name of the Unliving Room is "Dead Room (Dark)";
	now the printed name of the Inverted Dining Room is "Dining Room (Dark)";
	now the printed name of the Inverted Second Floor is "2nd Floor (Dark)";
	now the printed name of the Trespasser's Bedroom is "Trespasser's (Dark)";
	now the printed name of the Anti-Bedroom is "Master's (Dark)";
	now the printed name of the Inverted Upper Bathroom is "Other Bathroom (Dark)";
	now the printed name of the Floating Basement is "Basement (Dark again)";
	now the printed name of the Burning Cellar is "Fire Cellar (Dark)";
	say "...";
	wait for any key;
	say "That's weird. All the light's just went off.";
	wait for any key;
	say "...";
	wait for any key;
	say "I've got a bad feeling about this.";
	now the description of the Inverted Upper Bathroom is "[italic type]Don't leave.[roman type]";
	now the description of the Inverted Second Floor is "Four ways to go.";
	now the description of the Anti-Bedroom is "[italic type]He's still here.[roman type]";
	now the description of the Trespasser's Bedroom is "[italic type]Go away![roman type]";
	now the description of the Unliving Room is "[italic type]He lives...[roman type]";
	now the description of the Inverted Dining Room is "The cake is gone.";
	now the description of the Inverted Kitchen is "[italic type]So... hungry...[roman type]";
	now the description of the Long Hallway is "[italic type]Remember him?[roman type]";
	now the description of the Bloodroom is "Flahmie has left.";
	now the description of the Cemetery is "The moon is eclipsed.";
	now the description of the Inverted Lower Bathroom is "It's eerily quiet in here now.";
	now the description of the Inverted Bedroom is "[italic type]...for now.[roman type]";
	now the description of the Floating Basement is "What's that noise?";
	now the description of the Burning Cellar is "The flames are a little more calm.";
	now the description of the Back Dungeon is "The shrine is radiating.";
	now the cake is nowhere;
	now the description of the empty plate is "Empty again.";
	now the dormouse is nowhere;
	now the white wyvern is nowhere;
	now the giant egg is nowhere;
	now the description of the grandfather clock is "The mouse inside the clock is no longer there.";
	now the description of the fire is "Their still burning but are very small and quiet now.";
	now the description of the shrine is "There's something on the altar now.";
	now the description of the altar is "The plaque's message has changed.";
	now the description of the plaque is "'[italic type]Father Time.[roman type]'";
	now the description of the inverted photos are "[italic type]Remember me?[roman type]";
	now the description of the Mudroom is "The egg has hatched.";
	now the description of the platform is "Eggshell pieces is all that's left on it.";
	now the description of the Backyard is "It became darker outside.";
	now the description of the Dining Room is "The ghostly figure has disappeared.";
	now the ghost is nowhere;
	now the time wisp is on the altar.
	A time wisp is a thing. The time wisp is fixed in place.
	The description of the time wisp is "A strange glowing flame thing just sits on the altar. What a poser. It also seems to be to be making ticking noises like a clock."
	[Geez this is a lot of code. Don't screw with any of it or the game is unplayable up to this point.]

[The wisp - "I still love them. They raised me well and that's what matters."]
Before using the gold watch on the time wisp:
	say "[bold type]Note: This is the point of no return. Saving is recommended. Are you ready? (You can type 'Yes' instead of 'No' now when your ready.)[roman type]";
	if player consents, continue the action;
	otherwise stop the action.
	
After using the gold watch on the time wisp:
	say "You used your watch that you completely forgot you still had on you.";
	wait for any key;
	say "The way leading out of the dungeon closes slowly.";
	wait for any key;
	say "The wisp on the altar begins to react strangely to your watch.";
	wait for any key;
	say "Suddenly, a flash obscures your vision for a quick moment.";
	wait for any key;
	say "You regain you sight and an ominous figure appears in front of you.";
	wait for any key;
	say "It's...";
	wait for any key;
	say "you?";
	wait for any key;
	say "...";
	wait for any key;
	say "He appears to be holding something in his hand.";
	wait for any key;
	say "...";
	wait for any key;
	say "Prepare yourself...";
	wait for any key;
	say "for yourself.";
	say paragraph break;
	now the player is in the Arena;
	now the dog is scared;
	now the description of the dog is "[italic type]*shivering*[roman type]".
	The Arena is a room.
	The printed name of the Arena is "[one of]%H@^e#*3&L_L$!^o0*5)#[or]^@D(#E&_7$)!a)_$&3%Th2*[or]^@N*O$_+!8)#&0E4s{C.$&Ap^9E![or]<!?CO@>$01m5@!_E*)$+H=e6r?}E)([or]\%J@oiN*_4&()t-#9>HE,//67.2D<0aRk?n@$#^eSs{$@^[or]^@*i#_!aM9+038<ERr>#/^#*@26.?oR-&1%[at random]".
	The description of the Arena is "Looks like there is no escape."
	The doppleganger is in the Arena.

[Prevent saving the game during the Final Battle - "I'm over it now."]
Check saving the game:
	if the player can see the doppleganger:
		say "Too late for that.";
		stop the action.

Section 10.1 - The Final Fight

[Doppleganger fight - "Love never says 'die,' neither do Goonies."]
[Part 1]
After attacking the doppleganger when the doppleganger is guarding:
	say "The dark twin dodges the attack and attacks you back.[line break]You take damage.";
	now the doppleganger is a random attack pattern;
	now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
	now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
	now the dog is worried;
	now the description of the dog is "(Be careful.)"

After attacking the doppleganger when the doppleganger is guarding for the third time:
	record "Strike Three! Your Out!" as an ending;
	end the story saying "[one of]You missed too many times and was defeated.[or]You lack of skill has brought you to your demise.[or]Game Over Yeaaaaaaaaaaaah![at random]"

After waiting when the doppleganger is guarding:
	if the player can see the doppleganger:
		say "You patiently wait for an opportunity to attack.";
		now the doppleganger is a random attack pattern;
		now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
		now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
		now the dog is agitated;
		now the description of the dog is "[italic type]*Loud barking.*[roman type]";
	otherwise:
		continue the action.

After dodging the doppleganger when the doppleganger is guarding:
	say "[one of]You both are waiting for one of you to make a move. (Wow... what a lame fight this is turning out to be.)[or]You both stand there awkwardly waiting for someone to drop guard. (This is just ridiculous.)[or]You do realize he's guarding too, right?[at random]";
	now the doppleganger is a random attack pattern;
	now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
	now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
	now the dog is unamused;
	now the description of the dog is "(You serious, mate?)"

[Part 2]
After attacking the doppleganger when the doppleganger is charging:
	say "[one of]You chose the wrong move and was overpowered by the attack.[or]You were not quick enough to attack and got hit instead.[or]You had no luck; Damaged received.[at random]";
	now the doppleganger is a random attack pattern;
	now the dog is worried;
	now the description of the dog is "(Ouch.)"

After attacking the doppleganger when the doppleganger is charging for the sixth time:
	record "Hello Darkness" as an ending;
	end the story saying "[one of]The darkness managed to take you down. Better luck next time.[or]You succumbed to the darkness.[or] You had no chance of counterattacking and faced your inevitable demise.[at random]"

After waiting when the doppleganger is charging:
	if the player can see the doppleganger:
		say "[one of]How about you actually do something else other than standing still.[or]You took damage from not doing anything, Congratulations.[or]That was not a very wise move to do.[line break]Also you got hit.[at random]";
		now the doppleganger is a random attack pattern;
		now the dog is bewildered;
		now the description of the dog is "(Um...)";
	otherwise:
		continue the action.

After waiting when the doppleganger is charging for the sixth time:
	if the player can see the doppleganger:
		record "1/7 Sins" as an ending;
		end the story saying "[one of]Because of your downright laziness in doing anything, you died a pathetic death.[or]Idiot.[or]You kind of deserved that one.[or] You are dead; Not big surprise.[or]You Are Dead. Dead. Deeeeeeead.[at random]";
	otherwise:
		continue the action.

After dodging the doppleganger when the doppleganger is charging:
	say "[one of]You took no damage, good choice.[or]No damage was taken.[or]You dodged the attack just in time.[at random]";
	now the doppleganger is defenseless;
	now the dog is glad;
	now the description of the dog is "(Smart move.)"

[Part 3]
After attacking the doppleganger when the doppleganger is defenseless:
	say "[one of]Direct hit![or]Bull's eye![or]Take that, faker![or]Eat my shorts![at random]";
	now the doppleganger is a random attack pattern;
	now the dog is glad;
	now the description of the dog is "(Yeah!)"

After waiting when the doppleganger is defenseless:
	if the player can see the doppleganger:
		say "[one of]Seriously? That was your chance.[or]I'm not angry, just disappointed.[or]Running around in circles could have a better move than this one.[at random]";
		now the doppleganger is guarding;
		now the dog is unamused;
		now the description of the dog is "[italic type]*Annoyed look.*[roman type]";
	otherwise:
		continue the action.

After dodging the doppleganger when the doppleganger is defenseless:
	say "[one of]Dude. You blew you chance on hitting him.[or](I need to find a new player after all this is over.)[or]That's not...[or]Are you feeling alright, because he was wide open that time.[at random]";
	now the doppleganger is guarding;
	now the dog is disgusted;
	now the description of the dog is "[italic type]*sigh*[roman type]"

[Final Part]
After attacking the doppleganger when the doppleganger is defenseless for the 9th time:
	say "Doppleganger: '&#*(<>+_N7^45oOooo274(*&$OooOOoo(*75&*!!!(%&??490q865^3'";
	now the doppleganger is nowhere;
	now the left hand status line is "";
	now the printed name of the Arena is "???";
	now the description of the Arena is " ";
	now the dog is in the Arena;
	now the printed name of the dog is "Australian Shepherd";
	now the dog is quiet;
	now the description of the dog is "(Take the book.)";
	wait for any key;
	say "Doppleganger: '^#*(74.<.4Y*Y&*9ujN*YB&8nLmAo\Qtbym9K_)=0-=_+(>)k(MJ*&N(Yhj,umjh_+90_(08N)_9-SML*(mh,9LPO+)_987<l/-L0.-i<*(YN78.kIj,9hm8&N&7853De+AD{-dtGBT&8rmu,&#*902{(*#&(89854++-0_*976()-=;'";
	wait for any key;
	say "Doppleganger: ' *(&HN*y78t&^%Rbt768tVCE$R6eC&$SjW:Vr%BR%3<>?<.?LOmGk,l.<MLp{PO_0_{9)9c$2q^EV$DE%^eRBN&g^&*G68yH<Ju8jk.o_+_=)-*976Hy*&MHN^NSfW&R%6E46ERb7N*Y()(*(&'";
	wait for any key;
	say "Doppleganger: 'Y&*um89y&*(T67R*T&65vr%^y>?<./mkLHui(O*)_+(87^4D%wcFgYHRoFlllU&^BVb768YM*(u89I&*Y78y&*TV56ce45xEC%$v67689<90.K/)(K<9JM(*H78BT76BT6nHMyH,>./,.<MkjbYiy*(9(0-_9)86g%RVVBNjimUYGB567r$%34xSdrfhJBNbN<WtFz,M<>m.,mJKhyuTG67G+-)(07*yBB<MNm<?,.MkHjGTyuLoLl*OI{Pp{()89(y^&f%6e%$^78()9UIBGHCrtEt%6$3Wc5DVFtygBHVTdewr$#5^TuHjBN<M>M<>nHJg^&%^$5WSEpDF*SmB><.<Kj8i:9)O()864%ecV^b*(876*&6^AcdC+=-)gNYhUU*&y&(Il0I(78$5DCdVBFUNih*)(=_TL;dRgjQ+_)_*(<l'";
	wait for any key;
	say "...";
	wait for any key;
	say "[bold type]BOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOM!!!1!1![roman type]";
	wait for any key;
	clear only the main screen;
	now the reversed book is in the Arena.
	The reversed book is a thing.
	The description of the reversed book is "The book is backwards now."

Instead of taking the dog when the dog is quiet:
	say "No."

Section 10.3 - The True Ending

[The End - "I have a debilitating fear of roller coasters. Thanks a lot uncle."]
Before taking the reversed book:
	say "Take the book?";
	fake command 3;
	continue the action.

After taking the reversed book:
	say "As you pick up the book, the dog begins to glow.";
	wait for any key;
	say "He levitates up into the air and begins to transform.";
	wait for any key;
	say "After a blinding flash of light erupts, he turns into a man.";
	wait for any key;
	say "He wears an orange vest, just like the boy in the pictures.";
	wait for any key;
	say "Is...";
	wait for any key;
	say "Is this...";
	now the dog is nowhere;
	now the unknown man is in the Arena.
	The unknown man is a man.
	The description of the unknown man is "...Micheal?"
	Understand "Micheal" as unknown man.

Instead of taking the unknown man:
	say "..."

After talking to the unknown man:
	say "???: 'Hey there. Long time no see, old friend.'";
	wait for any key;
	say "???: 'You don't remember me, do you?'";
	wait for any key;
	say "???: 'I'm your old pal, Micheal.'";
	wait for any key;
	say "Micheal: 'I must thank you for dealing with that thing before. I didn't know you had it in ya.'";
	wait for any key;
	say "Micheal: 'You see, a long time ago I was working on some of my inventions that I was suppose to impress my colleagues with.'";
	wait for any key;
	say "Micheal: 'But once I was finished with that mirror portal device it started to act a little suspicious.'";
	wait for any key;
	say "Micheal: 'Next thing you know, a dark entity came out from the other side and made my other machines go on a fringe.'";
	wait for any key;
	say "Micheal: 'Short story, I was turned into a dog and all my loved ones memories of me were wiped out from existences due to the curse of this shapeshifter demon.'";
	wait for any key;
	say "Micheal: 'If you hadn't come back to find me and put an end to this devious being, I would have been lost is obscurity and not be freed by the curse of this house.'";
	wait for any key;
	say "Micheal: 'Plus who knew what would have happened if that thing managed to escape from the other side and enter the real world.'";
	wait for any key;
	say "Micheal: 'You're a hero, old sport.'";
	wait for any key;
	say "Micheal: 'Well... now that that's over with. Let's get outta here.'";
	wait for any key;
	clear only the main screen;
	now the player is in the Driveway;
	now the left hand status line is "[location]";
	say "After saving your old friend Micheal from a dreaded curse your memories of him began to flow back into you brain.";
	wait for any key;
	say "Both you and Micheal decided to lock away the mirror so that no one would ever have to see this horrible world for their own eyes.";
	wait for any key;
	say "Micheal decides to stay here to help rebuild everything he has done wrong in the past.";
	wait for any key;
	say "As for you, you decide to head back home and enjoy a nice relaxing cup of Joe for all your hard work.";
	wait for any key;
	say "Before you do leave, Micheal asks that if you ever find 'him' again to say that he's sorry for all the trouble he caused him and to take good loving care of him. He desperately needs it.";
	wait for any key;
	say "This, of course, was just what you were going to do all along.";
	wait for any key;
	say "And as you drive off into the distance, you spot a large shadow hovering past you. You stop to see what it is that's soaring above you.";
	wait for any key;
	say "It landed in the woods somewhere.";
	wait for any key;
	say "Looks like you know what to do.";
	wait for any key;
	clear only the main screen;
	center "The House of Mystery";
	wait for any key;
	center "By: James G. Lynch";
	wait for any key;
	center "Game made on Inform 7[line break]Full credits are in the help menu.";
	wait for any key;
	say paragraph break;
	say "Special thanks to all my friends, family, colleagues, professors and you, the player, for supporting me and motivating me into making this game. This game was made as a project for my New Media Perspectives class in college. It took me about 2 freaking months to make and it was all worth it at the very end. Please let me know what you thought of this game. It was a lot of fun to make and I hope you've enjoy this 'little' project of mine.";
	wait for any key;
	now the left hand status line is "Total turns: [turn count]";
	now the right hand status line is "";
	end the story finally saying "[bold type]The end... for real! Thank you for playing![roman type]".

Section A - Unlock It

Carry out switching on a sink:
	if 5 sinks are switched on:
		say "[italic type]You hear noises coming from 6 unknown locations.[roman type]";
		now Stone Tablet 1 is in the Living Room;
		now Stone Tablet 2 is in the Cellar;
		now Stone Tablet 3 is in the Master Bedroom;
		now Stone Tablet 4 is in the Trespasser's Bedroom;
		now Stone Tablet 5 is in the Bloodroom;
		now Stone Tablet 6 is in the Back Dungeon.

Stone tablet is a kind of thing.
Stone Tablet 1 is a stone tablet.
Stone Tablet 2 is a stone tablet.
Stone Tablet 3 is a stone tablet.
Stone Tablet 4 is a stone tablet.
Stone Tablet 5 is a stone tablet.
Stone Tablet 6 is a stone tablet.

The description of Stone Tablet 1 is "7".
The description of Stone Tablet 2 is "9".
The description of Stone Tablet 3 is "5".
The description of Stone Tablet 4 is "0".
The description of Stone Tablet 5 is "6".
The description of Stone Tablet 6 is "1".

Section B - Secret

After entering the shed door:
	say "You've entered the secret room.";
	now the player is in the Debug Room.

The Debug Room is a room. The description of the Debug Room is "Welcome to the Debug Room!"
The exit door is in the Debug Room.
The exit door is a door. The exit door is west of the Debug Room. Through it is the Backyard.

Sign 1, Sign 2, Sign 3, Sign 4, Sign 5, Sign 6, and Sign X are in the Debug Room.
The printed name of Sign 1 is "Debug Cheat's Sign".
The printed name of Sign 2 is "Question's List (1-25)".
The printed name of Sign 3 is "Question's List (26-50)".
The printed name of Sign 4 is "Test Command List".
The printed name of Sign 5 is "Picture Files".
The printed name of Sign 6 is "Unused Content".
The printed name of Sign X is "A sign that says 'Do NOT read or examine this sign or else run-time error might occur.'"

The description of Sign 1 is "Debug Cheat's (Not in the release version):[paragraph break]Universal rule 1 is an action applying to nothing.[line break]Understand 'imsickofalltheselockeddoors' as universal rule 1.[line break]Carry out universal rule 1: now all doors are unlocked;[line break]now all doors are open.[line break]Report universal rule 1: say 'Open Sesame!'[paragraph break]Universal rule 2 is an action applying to nothing.[line break]Understand 'magicmirroronthewall' as universal rule 2.[line break]Carry out universal rule 2: now the player is carrying the scepter.[line break]Report universal rule 2: say 'Whose the fairest? Not you, cheater!'[paragraph break]Universal rule 3 is an action applying to nothing.[line break]Understand 'myheadisnaked' as universal rule 3.[line break]Carry out universal rule 3: now the player is carrying the red pinned hat.[line break]Report universal rule 3: say 'Then don't go out in public.'[paragraph break]Universal rule 4 is an action applying to nothing.[line break]Understand 'itsfreezinginhere' as universal rule 4.[line break]Carry out universal rule 4: now the player is carrying the thermal coat.[line break]Report universal rule 4: say 'Then put on some layers.'[paragraph break]Universal rule 5 is an action applying to nothing.[line break]Understand 'lightsplease420' as universal rule 5.[line break]Carry out universal rule 5: now all rooms are lit.[line break]Report universal rule 5: say 'Let there be light!'[paragraph break]Universal rule 6 is an action applying to nothing.[line break]Understand 'sorrynotsorry' as universal rule 6.[line break]Carry out universal rule 6: now the dog is content.[line break]Report universal rule 6: say 'That's such a stupid phrase.'[paragraph break]Universal rule 7 is an action applying to nothing.[line break]Understand 'secretofmana' as universal rule 7.[line break]Carry out universal rule 7: now the white wyvern is content.[line break]Report universal rule 7: say 'Have you ever played it?'[paragraph break]Universal rule 8 is an action applying to nothing.[line break]Understand 'takingnotes' as universal rule 8.[line break]Carry out universal rule 8: now the player is carrying Note #1;[line break]now the player is carrying Note #2;[line break]now the player is carrying Note #3;[line break]now the player is carrying Note #4;[line break]now the player is carrying Note #6;[line break]now the player is carrying Note #7;[line break]now the player is carrying Note #8;[line break]now the player is carrying Note #9.[line break]Report universal rule 8: say 'Gotta read [']em all!'[paragraph break]Universal rule 9 is an action applying to nothing.[line break]Understand 'ruinthefun' as universal rule 9.[line break]Carry out universal rule 9: now the player is carrying the Excalibur;[line break]now the player is in the Arena.[line break]Report universal rule 9: say 'Thou art has doth ruin thee fun.'"
The description of Sign 2 is "1. How old are you?[line break]2. What are you?[line break]3. How many licks does it take to get to the center of a Tootsie Pop?[line break]4. How is this house mysterious?[line break]5. Are you a lizard?[line break]6. Who am I really talking to?[line break]7. Why do I need to wear a hat to go upstairs?[line break]8. Am I dead? / Am I dreaming?[line break]9. I found a misspelled word. / I found a grammar issue. / I found a bug. / I found an error. / I found a punctuation error.[line break]10. Who am I?[line break]11. Why did you make a text-based game?[line break]12. Why are you such a smartass? / Why are you so sarcastic? / Why are you so weird?[line break]13. What is the other side?[line break]14. Is this place real? / Is this house real?[line break]15. How much wood can a woodchuck chuck if a woodchuck could chuck wood?[line break]16. Can I stream this on twitch? / Can I record this on youtube?[line break]17. Why can't I say naughty things in this game? / Why can't I cuss? / Why can't I swear? / Why can't I curse?[line break]18. Are you male or female? / What is your gender?[line break]19. Tell me about the school model.[line break]20. Why are there so many questions?[line break]21. I checked the source code. / I checked the source text.[line break]22. About the dog. / Tell me about the dog.[line break]23. About the mouse. / Tell me about the mouse.[line break]24. About the wyvern. / Tell me about the wyvern. / About Flahmie. / Tell me about Flahmie.[line break]25. Why are there almost no people in this game? / Why are there almost no people here?"
The description of Sign 3 is "26. What is the point of these questions being commands? / What is the point of these statements being commands?[line break]27. Why do I have telepathy? / How do I have telepathy?[line break]28. What kind of dreams do you have? / Tell me about your dreams.[line break]29. Why does the map look so cheap? / Why is the map hard to read? / Why is the map hard to see? / Why does the map look weird?[line break]30. The solution file is hard to understand. / The solution file is too simple.[line break]31. What's 9+10?[line break]32. This sentence is false. / This statement is false.[line break]33. Do you have siblings?[line break]34. Why are there so many curse words? / Why are there so many bad words?[line break]35. Do you have parents?[line break]36. What is the loneliest number?[line break]37. What is your favorite season(s)?[line break]38. How many references are in this game?[line break]39. Got any secrets?[line break]40. Why did this update take so long?[line break]41. Are you a wizard?[line break]42. What is the answer to life, the universe and everything?[line break]43. Stop breaking the 4th wall. / Stop breaking the fourth wall.[line break]44. How many fingers am I holding up?[line break]45. There's no music in this game.[line break]46. Tell me a tongue twister.[line break]47. Tell me a joke.[line break]48. When's your birthday?[line break]49. How's college?[line break]50. What's with the cryptic messages in the source text? / What's with the cryptic messages in the source code?"
The description of Sign 4 is "Test commands (Not in the release version):[paragraph break]>test tv[line break]>test door[line break]>test food[line break]>test kick[line break]>test bug[line break]>test closet[line break]>test hat[line break]>test ink[line break]>test switch[line break]>test flowers[line break]>test clothes[line break]>test bedroom".
The description of Sign 5 is "Picture's used so far:".
The description of Sign 6 is "Unused, Changed, or Removed Content:".
The description of Sign X is "You had one job and you failed. (Don't do it again!)".

Every turn when examining Sign X:
	[end the story saying "One. Job.";]
	choose a random row from the Table of You're Screwed Errors;
	blank out the whole row;
	now the description of Sign X is "You failed again."

Before examining Sign X for the third time:
	now the description of Sign X is "Goodbye."

After examining Sign X three times:
	stop game abruptly.

Table of You're Screwed Errors
error	message	toggle
"Syntax11"	"You had one job."	hint toggle rule